#!/usr/bin/python

import doodle, os, tempfile

T = tempfile.mkdtemp()
TDB = os.path.join(T,"test.db")
TEST = map(lambda x:os.path.join(T,x),["./path/one/first_filename", "./path/one/first_filename", "./path/two/first_filename", "./path/two/second_filename"])

def doodle_logger(level, message):
	print "doodle-log: (%d) %s"%(level,message)

if os.path.exists(TDB):
	os.remove(TDB)
for i in TEST:
	os.system("mkdir -p %s"%(os.path.split(i)[0]))
	os.system("touch %s"%(i))

st = doodle.SuffixTree(dbname=TDB,flags=doodle.ST_READWRITE,logger=doodle_logger)
st.expand("SEARCHDOODLE",TEST[0])
st.expand("DOODLE",TEST[1])
st.expand("SEARCH",TEST[2])
st.expand("NONE",TEST[3])

st.sync()

print st.filename, st.count, st.logger, st.flags

st.close()

print st.filename, st.count, st.logger, st.flags

st = doodle.SuffixTree(dbname=TDB,flags=0,logger=doodle_logger)

print st.filename, st.count, st.logger, st.flags

print st.treeSearch("DOODLE")
print st.treeSearchApprox("doodle",ignorecase=1)
print st.treeSearch("SEARCH")
print st.treeSearchApprox("syyrch",approx=1,ignorecase=1)
print st.treeSearchApprox("syyrch",approx=2,ignorecase=1)
print st.treeSearchApprox("searchy",approx=3,ignorecase=1)

for i in st:
	print "indexed: "+str(i)
