/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.jtb.misc;

import EDU.purdue.jtb.misc.Globals;

class AutoClasses {
    static final String packageName = Globals.nodePackage;

    AutoClasses() {
    }

    static String getNodeChoiceClassStr() {
        return "package " + packageName + ";\n\n" + "/**\n" + " * Represents a grammar choice, e.g. ( A | B )\n" + " */\n" + "public class NodeChoice" + (Globals.nodeSuperclass != null ? " extends " + Globals.nodeSuperclass : "") + " implements Node {\n" + "   public NodeChoice(Node node) {\n" + "      this(node, -1);\n" + "   }\n\n" + "   public NodeChoice(Node node, int whichChoice) {\n" + "      choice = node;\n" + (Globals.parentPointers ? "      choice.setParent(this);\n" : "") + "      which = whichChoice;\n" + "   }\n\n" + "   public void accept(" + Globals.visitorPackage + ".Visitor v) {\n" + "      choice.accept(v);\n" + "   }\n" + "   public Object accept(" + Globals.visitorPackage + ".ObjectVisitor v, Object argu) {\n" + "      return choice.accept(v,argu);\n" + "   }\n\n" + AutoClasses.parentPointerCode() + "   public Node choice;\n" + "   public int which;\n" + "}\n";
    }

    static String getNodeClassStr() {
        StringBuffer stringBuffer = new StringBuffer("package " + packageName + ";\n\n" + "/**\n" + " * The interface which all syntax tree classes must implement.\n" + " */\n" + "public interface Node extends java.io.Serializable {\n" + "   public void accept(" + Globals.visitorPackage + ".Visitor v);\n" + "   public Object accept(" + Globals.visitorPackage + ".ObjectVisitor v, Object argu);\n\n");
        if (Globals.parentPointers) {
            stringBuffer.append("   // It is the responsibility of each implementing class to call\n   // setParent() on each of its child Nodes.\n   public void setParent(Node n);\n   public Node getParent();\n");
        }
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    static String getNodeListClassStr() {
        StringBuffer stringBuffer = new StringBuffer("package " + packageName + ";\n\n" + "import java.util.*;\n\n" + "/**\n" + " * Represents a grammar list, e.g. ( A )+\n" + " */\n" + "public class NodeList" + (Globals.nodeSuperclass != null ? " extends " + Globals.nodeSuperclass : "") + " implements NodeListInterface {\n" + "   public NodeList() {\n" + "      nodes = new Vector();\n" + "   }\n\n" + "   public NodeList(Node firstNode) {\n" + "      nodes = new Vector();\n" + "      addNode(firstNode);\n" + "   }\n\n" + "   public void addNode(Node n) {\n" + "      nodes.addElement(n);\n" + (Globals.parentPointers ? "      n.setParent(this);\n" : "") + "   }\n\n" + "   public Enumeration elements() { return nodes.elements(); }\n" + "   public Node elementAt(int i)  { return (Node)nodes.elementAt(i); }\n" + "   public int size()             { return nodes.size(); }\n" + "   public void accept(" + Globals.visitorPackage + ".Visitor v) {\n" + "      v.visit(this);\n" + "   }\n" + "   public Object accept(" + Globals.visitorPackage + ".ObjectVisitor v, Object argu) {\n" + "      return v.visit(this,argu);\n" + "   }\n\n" + AutoClasses.parentPointerCode() + "   public Vector nodes;\n" + "}\n");
        return stringBuffer.toString();
    }

    static String getNodeListInterfaceClassStr() {
        return "package " + packageName + ";\n\n" + "/**\n" + " * The interface which NodeList, NodeListOptional, and NodeSequence\n" + " * implement.\n" + " */\n" + "public interface NodeListInterface extends Node {\n" + "   public void addNode(Node n);\n" + "   public Node elementAt(int i);\n" + "   public java.util.Enumeration elements();\n" + "   public int size();\n" + "}\n";
    }

    static String getNodeListOptionalClassStr() {
        StringBuffer stringBuffer = new StringBuffer("package " + packageName + ";\n\n" + "import java.util.*;\n\n" + "/**\n" + " * Represents an optional grammar list, e.g. ( A )*\n" + " */\n" + "public class NodeListOptional" + (Globals.nodeSuperclass != null ? " extends " + Globals.nodeSuperclass : "") + " implements NodeListInterface {\n" + "   public NodeListOptional() {\n" + "      nodes = new Vector();\n" + "   }\n\n" + "   public NodeListOptional(Node firstNode) {\n" + "      nodes = new Vector();\n" + "      addNode(firstNode);\n" + "   }\n\n" + "   public void addNode(Node n) {\n" + "      nodes.addElement(n);\n" + (Globals.parentPointers ? "      n.setParent(this);\n" : "") + "   }\n\n" + "   public Enumeration elements() { return nodes.elements(); }\n" + "   public Node elementAt(int i)  { return (Node)nodes.elementAt(i); }\n" + "   public int size()             { return nodes.size(); }\n" + "   public boolean present()      { return nodes.size() != 0; }\n" + "   public void accept(" + Globals.visitorPackage + ".Visitor v) {\n" + "      v.visit(this);\n" + "   }\n" + "   public Object accept(" + Globals.visitorPackage + ".ObjectVisitor v, Object argu) {\n" + "      return v.visit(this,argu);\n" + "   }\n\n" + AutoClasses.parentPointerCode() + "   public Vector nodes;\n" + "}\n");
        return stringBuffer.toString();
    }

    static String getNodeListOptionalVisitorStr() {
        return "   public Object visit(NodeListOptional n, Object argu);\n";
    }

    static String getNodeListVisitorStr() {
        return "   public Object visit(NodeList n, Object argu);\n";
    }

    static String getNodeOptionalClassStr() {
        StringBuffer stringBuffer = new StringBuffer("package " + packageName + ";\n\n" + "/**\n" + " * Represents an grammar optional node, e.g. ( A )? or [ A ]\n" + " */\n" + "public class NodeOptional" + (Globals.nodeSuperclass != null ? " extends " + Globals.nodeSuperclass : "") + " implements Node {\n" + "   public NodeOptional() {\n" + "      node = null;\n" + "   }\n\n" + "   public NodeOptional(Node n) {\n" + "      addNode(n);\n" + "   }\n\n" + "   public void addNode(Node n)  {\n" + "      if ( node != null)                // Oh oh!\n" + "         throw new Error(\"Attempt to set optional node twice\");\n\n" + "      node = n;\n" + (Globals.parentPointers ? "      n.setParent(this);\n" : "") + "   }\n" + "   public void accept(" + Globals.visitorPackage + ".Visitor v) {\n" + "      v.visit(this);\n" + "   }\n" + "   public Object accept(" + Globals.visitorPackage + ".ObjectVisitor v, Object argu) {\n" + "      return v.visit(this,argu);\n" + "   }\n" + "   public boolean present()   { return node != null; }\n\n" + AutoClasses.parentPointerCode() + "   public Node node;\n" + "}\n");
        return stringBuffer.toString();
    }

    static String getNodeOptionalVisitorStr() {
        return "   public Object visit(NodeOptional n, Object argu);\n";
    }

    static String getNodeSequenceClassStr() {
        StringBuffer stringBuffer = new StringBuffer("package " + packageName + ";\n\n" + "import java.util.*;\n\n" + "/**\n" + " * Represents a sequence of nodes nested within a choice, list,\n" + " * optional list, or optional, e.g. ( A B )+ or [ C D E ]\n" + " */\n" + "public class NodeSequence" + (Globals.nodeSuperclass != null ? " extends " + Globals.nodeSuperclass : "") + " implements NodeListInterface {\n" + "   public NodeSequence(int n) {\n" + "      nodes = new Vector(n);\n" + "   }\n\n" + "   public NodeSequence(Node firstNode) {\n" + "      nodes = new Vector();\n" + "      addNode(firstNode);\n" + "   }\n\n" + "   public void addNode(Node n) {\n" + "      nodes.addElement(n);\n" + (Globals.parentPointers ? "      n.setParent(this);\n" : "") + "   }\n\n" + "   public Node elementAt(int i)  { return (Node)nodes.elementAt(i); }\n" + "   public Enumeration elements() { return nodes.elements(); }\n" + "   public int size()             { return nodes.size(); }\n" + "   public void accept(" + Globals.visitorPackage + ".Visitor v) {\n" + "      v.visit(this);\n" + "   }\n" + "   public Object accept(" + Globals.visitorPackage + ".ObjectVisitor v, Object argu) {\n" + "      return v.visit(this,argu);\n" + "   }\n\n" + AutoClasses.parentPointerCode() + "   public Vector nodes;\n" + "}\n");
        return stringBuffer.toString();
    }

    static String getNodeSequenceVisitorStr() {
        return "   public Object visit(NodeSequence n, Object argu);\n";
    }

    static String getNodeTokenClassStr() {
        StringBuffer stringBuffer = new StringBuffer("package " + packageName + ";\n\n" + "import java.util.*;\n" + "/**\n" + " * Represents a single token in the grammar.  If the \"-tk\" option\n" + " * is used, also contains a Vector of preceding special tokens.\n" + " */\n" + "public class NodeToken" + (Globals.nodeSuperclass != null ? " extends " + Globals.nodeSuperclass : "") + " implements Node {\n" + "   public NodeToken(String s) {\n" + "      this(s, -1, -1, -1, -1, -1); " + "   }\n\n" + "   public NodeToken(String s, int kind, int beginLine, int beginColumn, int endLine, int endColumn) {\n" + "      tokenImage = s;\n" + "      specialTokens = null;\n" + "      this.kind = kind;\n" + "      this.beginLine = beginLine;\n" + "      this.beginColumn = beginColumn;\n" + "      this.endLine = endLine;\n" + "      this.endColumn = endColumn;\n" + "   }\n\n" + "   public NodeToken getSpecialAt(int i) {\n" + "      if ( specialTokens == null )\n" + "         throw new NoSuchElementException(\"No specials in token\");\n" + "      return (NodeToken)specialTokens.elementAt(i);\n" + "   }\n\n" + "   public int numSpecials() {\n" + "      if ( specialTokens == null ) return 0;\n" + "      return specialTokens.size();\n" + "   }\n\n" + "   public void addSpecial(NodeToken s) {\n" + "      if ( specialTokens == null ) specialTokens = new Vector();\n" + "      specialTokens.addElement(s);\n" + (Globals.parentPointers ? "      s.setParent(this);\n" : "") + "   }\n\n" + "   public void trimSpecials() {\n" + "      if ( specialTokens == null ) return;\n" + "      specialTokens.trimToSize();\n" + "   }\n\n" + "   public String toString()     { return tokenImage; }\n\n" + "   public String withSpecials() {\n" + "      if ( specialTokens == null )\n" + "          return tokenImage;\n\n" + "       StringBuffer buf = new StringBuffer();\n\n" + "       for ( Enumeration e = specialTokens.elements(); e.hasMoreElements(); )\n" + "          buf.append(e.nextElement().toString());\n\n" + "       buf.append(tokenImage);\n" + "       return buf.toString();\n" + "   }\n\n" + "   public void accept(" + Globals.visitorPackage + ".Visitor v) {\n" + "      v.visit(this);\n" + "   }\n" + "   public Object accept(" + Globals.visitorPackage + ".ObjectVisitor v, Object argu) {\n" + "      return v.visit(this,argu);\n" + "   }\n\n" + AutoClasses.parentPointerCode() + "   public String tokenImage;\n\n" + "   // Stores a list of NodeTokens\n" + "   public Vector specialTokens;\n\n" + "   // -1 for these ints means no position info is available.\n" + "   public int beginLine, beginColumn, endLine, endColumn;\n\n" + "   // Equal to the JavaCC token \"kind\" integer.\n" + "   // -1 if not available.\n" + "   public int kind;\n" + "}\n");
        return stringBuffer.toString();
    }

    static String getNodeTokenVisitorStr() {
        return "   public Object visit(NodeToken n, Object argu);\n";
    }

    static String parentPointerCode() {
        if (Globals.parentPointers) {
            return "   public void setParent(Node n) { parent = n; }\n   public Node getParent()       { return parent; }\n\n   private Node parent;\n";
        }
        return "";
    }
}

