/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.jtb.misc;

import EDU.purdue.jtb.misc.Errors;
import EDU.purdue.jtb.misc.FieldNameGenerator;
import EDU.purdue.jtb.misc.Globals;
import EDU.purdue.jtb.misc.Spacing;
import EDU.purdue.jtb.syntaxtree.Expansion;
import EDU.purdue.jtb.syntaxtree.ExpansionChoices;
import EDU.purdue.jtb.syntaxtree.ExpansionUnit;
import EDU.purdue.jtb.syntaxtree.ExpansionUnitTerm;
import EDU.purdue.jtb.syntaxtree.LocalLookahead;
import EDU.purdue.jtb.syntaxtree.NodeChoice;
import EDU.purdue.jtb.syntaxtree.NodeOptional;
import EDU.purdue.jtb.syntaxtree.NodeSequence;
import EDU.purdue.jtb.syntaxtree.NodeToken;
import EDU.purdue.jtb.visitor.Printer;
import java.io.PrintWriter;
import java.util.Enumeration;

class CommentPrinter
extends Printer {
    private boolean visitedLookahead = false;
    private Spacing spc;
    private int nestLevel = 0;
    private int fieldNum = 0;
    private FieldNameGenerator nameGen = new FieldNameGenerator();

    CommentPrinter(PrintWriter printWriter, Spacing spacing) {
        super(printWriter);
        this.spc = spacing;
    }

    private String getUnitName(ExpansionUnit expansionUnit) {
        switch (expansionUnit.f0.which) {
            case 2: {
                NodeSequence nodeSequence = (NodeSequence)expansionUnit.f0.choice;
                NodeOptional nodeOptional = (NodeOptional)nodeSequence.elementAt(3);
                if (nodeOptional.present()) {
                    NodeChoice nodeChoice = (NodeChoice)nodeOptional.node;
                    String string = ((NodeToken)nodeChoice.choice).tokenImage;
                    return this.nameGen.getNameForMod(string);
                }
                ExpansionChoices expansionChoices = (ExpansionChoices)nodeSequence.elementAt(1);
                if (expansionChoices.f1.present()) {
                    return "NodeChoice";
                }
                return "NodeSequence";
            }
            case 3: {
                return "NodeOptional";
            }
            case 4: {
                NodeSequence nodeSequence = (NodeSequence)expansionUnit.f0.choice;
                ExpansionUnitTerm expansionUnitTerm = (ExpansionUnitTerm)nodeSequence.elementAt(1);
                if (expansionUnitTerm.f0.which == 0) {
                    return "NodeToken";
                }
                NodeSequence nodeSequence2 = (NodeSequence)expansionUnitTerm.f0.choice;
                return ((NodeToken)nodeSequence2.elementAt((int)0)).tokenImage;
            }
        }
        Errors.hardErr("n.f0.which = " + String.valueOf(expansionUnit.f0.which));
        throw new Error("Error in CommentPrinter.getUnitName()");
    }

    public void visit(Expansion expansion) {
        if (!expansion.f0.present()) {
            return;
        }
        Enumeration enumeration = expansion.f0.elements();
        ExpansionUnit expansionUnit = (ExpansionUnit)enumeration.nextElement();
        this.visitedLookahead = false;
        if (this.nestLevel == 0 && expansionUnit.f0.which != 0 && expansionUnit.f0.which != 1) {
            this.out.print(String.valueOf(this.spc.spc) + " * " + this.nameGen.curFieldName(this.getUnitName(expansionUnit)) + " -> ");
        }
        ++this.nestLevel;
        if (expansionUnit.f0.which != 1) {
            expansionUnit.accept(this);
        }
        --this.nestLevel;
        while (enumeration.hasMoreElements()) {
            expansionUnit = (ExpansionUnit)enumeration.nextElement();
            if (!this.visitedLookahead) {
                if (expansionUnit.f0.which != 0 && expansionUnit.f0.which != 1) {
                    if (this.nestLevel == 0) {
                        this.out.println();
                        this.out.print(String.valueOf(this.spc.spc) + " * " + this.nameGen.curFieldName(this.getUnitName(expansionUnit)) + " -> ");
                    } else {
                        this.out.print(" ");
                    }
                }
            } else {
                this.visitedLookahead = false;
            }
            ++this.nestLevel;
            if (expansionUnit.f0.which != 1) {
                expansionUnit.accept(this);
            }
            --this.nestLevel;
        }
    }

    public void visit(ExpansionChoices expansionChoices) {
        if (!expansionChoices.f1.present()) {
            expansionChoices.f0.accept(this);
            return;
        }
        if (this.nestLevel == 0) {
            this.out.print(String.valueOf(this.spc.spc) + " * " + this.nameGen.curFieldName("NodeChoice") + " -> ");
        }
        ++this.nestLevel;
        expansionChoices.f0.accept(this);
        --this.nestLevel;
        Enumeration enumeration = expansionChoices.f1.elements();
        while (enumeration.hasMoreElements()) {
            NodeSequence nodeSequence = (NodeSequence)enumeration.nextElement();
            if (this.nestLevel == 0) {
                this.out.println();
                this.out.print(String.valueOf(this.spc.spc) + " *       ");
            } else {
                this.out.print(" ");
            }
            this.out.print(String.valueOf(String.valueOf(nodeSequence.elementAt(0))) + " ");
            ++this.nestLevel;
            nodeSequence.elementAt(1).accept(this);
            --this.nestLevel;
        }
    }

    public void visit(LocalLookahead localLookahead) {
        this.visitedLookahead = true;
    }

    public void visit(NodeToken nodeToken) {
        if (!Globals.javaDocComments) {
            this.out.print(nodeToken.tokenImage);
        } else {
            int n = 0;
            while (n < nodeToken.tokenImage.length()) {
                char c = nodeToken.tokenImage.charAt(n);
                if (c == '<') {
                    this.out.print("&lt;");
                } else if (c == '>') {
                    this.out.print("&gt;");
                } else {
                    this.out.print(c);
                }
                ++n;
            }
        }
    }
}

