/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.jtb.misc.toolkit;

import EDU.purdue.jtb.misc.ClassInfo;
import EDU.purdue.jtb.misc.Errors;
import EDU.purdue.jtb.misc.FileExistsException;
import EDU.purdue.jtb.misc.Globals;
import EDU.purdue.jtb.misc.Spacing;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class SchemeVisitorBuilder {
    public static final String visitorName = "SchemeTreeBuilder";
    public static final String outFilename = "SchemeTreeBuilder.java";
    public static final int INDENT_AMT = 3;
    private Vector classList;
    private File visitorDir;
    private PrintWriter out;

    public SchemeVisitorBuilder(Vector vector) {
        this.classList = vector;
        this.visitorDir = new File(Globals.visitorDir);
        if (!this.visitorDir.exists()) {
            this.visitorDir.mkdir();
        }
    }

    public void generateSchemeBuilder() throws FileExistsException {
        try {
            File file = new File(this.visitorDir, outFilename);
            if (Globals.noOverwrite && file.exists()) {
                throw new FileExistsException(outFilename);
            }
            this.out = new PrintWriter(new FileOutputStream(file), false);
            Spacing spacing = new Spacing(3);
            boolean bl = true;
            this.out.println(Globals.fileHeader(spacing));
            this.out.println();
            this.out.println(String.valueOf(spacing.spc) + "package " + Globals.visitorPackage + ";");
            if (!Globals.visitorPackage.equals(Globals.nodePackage)) {
                this.out.println(String.valueOf(spacing.spc) + "import " + Globals.nodePackage + ".*;");
            }
            this.out.println(String.valueOf(spacing.spc) + "import java.util.*;");
            this.out.println(String.valueOf(spacing.spc) + "import java.io.*;");
            this.out.println();
            this.out.println(String.valueOf(spacing.spc) + "/**");
            this.out.println(String.valueOf(spacing.spc) + " * Generates a syntax tree in the Scheme " + "language.");
            this.out.println(String.valueOf(spacing.spc) + " */");
            this.out.println(String.valueOf(spacing.spc) + "public class " + visitorName + " extends " + "DepthFirstVisitor" + " {");
            spacing.updateSpc(1);
            this.out.println(String.valueOf(spacing.spc) + "PrintWriter out;");
            this.out.println();
            this.printAutoMethods();
            this.out.println();
            Enumeration enumeration = this.classList.elements();
            while (enumeration.hasMoreElements()) {
                ClassInfo classInfo = (ClassInfo)enumeration.nextElement();
                String string = classInfo.getName();
                String string2 = (String)classInfo.getTypeList().elementAt(0);
                this.out.println(String.valueOf(spacing.spc) + "/**");
                if (Globals.javaDocComments) {
                    this.out.println(String.valueOf(spacing.spc) + " * <PRE>");
                }
                this.out.println(classInfo.getEbnfProduction(spacing));
                if (Globals.javaDocComments) {
                    this.out.println(String.valueOf(spacing.spc) + " * </PRE>");
                }
                this.out.println(String.valueOf(spacing.spc) + " */");
                this.out.print(String.valueOf(spacing.spc) + "public void visit");
                this.out.println("(" + string + " n) {");
                spacing.updateSpc(1);
                if (bl) {
                    this.out.println(String.valueOf(spacing.spc) + "out.print(\"(define root '(" + string + " \");");
                } else if (classInfo.getNameList().size() > 1 || !string2.equals("NodeChoice")) {
                    this.out.println(String.valueOf(spacing.spc) + "out.print(\"(" + string + " \");");
                }
                Enumeration enumeration2 = classInfo.getNameList().elements();
                while (enumeration2.hasMoreElements()) {
                    this.out.println(String.valueOf(spacing.spc) + "n." + (String)enumeration2.nextElement() + ".accept(this);");
                }
                if (bl) {
                    this.out.println(String.valueOf(spacing.spc) + "out.print(\")) \");");
                    this.out.println(String.valueOf(spacing.spc) + "out.flush();");
                    this.out.println(String.valueOf(spacing.spc) + "out.close();");
                    bl = false;
                } else if (classInfo.getNameList().size() > 1 || !string2.equals("NodeChoice")) {
                    this.out.println(String.valueOf(spacing.spc) + "out.print(\") \");");
                }
                spacing.updateSpc(-1);
                this.out.println(String.valueOf(spacing.spc) + "}\n");
            }
            spacing.updateSpc(-1);
            this.out.println(String.valueOf(spacing.spc) + "}");
            this.out.flush();
            this.out.close();
        }
        catch (IOException iOException) {
            Errors.hardErr("Could not generate SchemeTreeBuilder.java");
        }
    }

    private void printAutoMethods() {
        this.out.println("   public SchemeTreeBuilder() {\n      this(System.out);\n   }\n\n   public SchemeTreeBuilder(Writer w) {\n      out = new PrintWriter(w);\n   }\n\n   public SchemeTreeBuilder(OutputStream o) {\n      out = new PrintWriter(o);\n   }\n\n   private String toSchemeString(String s) {\n      int len = s.length();\n      StringBuffer temp = new StringBuffer(s);\n\n      for ( int i = 0; i < len; i++ )\n         if ( temp.charAt(i) == '\"' ) {\n            temp.insert(i, '\\\\');\n            ++i; ++len;\n         }\n\n      return temp.toString();\n   }\n\n");
        this.out.println("   public void visit(NodeList n) {\n      out.print(\"(\");\n      for ( Enumeration e = n.elements(); e.hasMoreElements(); )\n         ((Node)e.nextElement()).accept(this);\n      out.print(\") \");\n   }\n\n   public void visit(NodeListOptional n) {\n      out.print(\"( \");\n      for ( Enumeration e = n.elements(); e.hasMoreElements(); )\n         ((Node)e.nextElement()).accept(this);\n      out.print(\") \");\n   }\n\n   public void visit(NodeOptional n) {\n      out.print(\"(\");\n      if ( n.present() )\n         n.node.accept(this);\n      out.print(\") \");\n   }\n\n   public void visit(NodeToken n) {\n      out.print(\"\\\"\" + toSchemeString(n.tokenImage) + \"\\\" \");\n   }\n");
    }
}

