/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.jtb.visitor;

import EDU.purdue.jtb.misc.Errors;
import EDU.purdue.jtb.misc.FileExistsException;
import EDU.purdue.jtb.misc.Globals;
import EDU.purdue.jtb.misc.VarInfo;
import EDU.purdue.jtb.syntaxtree.BNFProduction;
import EDU.purdue.jtb.syntaxtree.Expansion;
import EDU.purdue.jtb.syntaxtree.ExpansionChoices;
import EDU.purdue.jtb.syntaxtree.ExpansionUnit;
import EDU.purdue.jtb.syntaxtree.ExpansionUnitTerm;
import EDU.purdue.jtb.syntaxtree.JavaCCInput;
import EDU.purdue.jtb.syntaxtree.JavaCodeProduction;
import EDU.purdue.jtb.syntaxtree.LocalLookahead;
import EDU.purdue.jtb.syntaxtree.Node;
import EDU.purdue.jtb.syntaxtree.NodeChoice;
import EDU.purdue.jtb.syntaxtree.NodeListOptional;
import EDU.purdue.jtb.syntaxtree.NodeOptional;
import EDU.purdue.jtb.syntaxtree.NodeSequence;
import EDU.purdue.jtb.syntaxtree.NodeToken;
import EDU.purdue.jtb.syntaxtree.RegularExprProduction;
import EDU.purdue.jtb.syntaxtree.RegularExpression;
import EDU.purdue.jtb.visitor.ExpansionUnitTypeCounter;
import EDU.purdue.jtb.visitor.ImportInserter;
import EDU.purdue.jtb.visitor.Printer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;

public class Annotator
extends Printer {
    private Printer plainPrinter;
    private int varNum;
    private Vector varList;
    private Vector outerVars;
    private VarInfo prevVar;
    private boolean annotateNode;
    private String curProduction;
    private Vector specialList = null;

    public Annotator() throws FileExistsException {
        this(Globals.outFilename);
    }

    public Annotator(OutputStream outputStream) {
        super(outputStream);
        this.out = new PrintWriter(outputStream);
        this.plainPrinter = new Printer(this.out, this.spc);
    }

    public Annotator(Writer writer) {
        super(writer);
        this.out = new PrintWriter(writer);
        this.plainPrinter = new Printer(this.out, this.spc);
    }

    public Annotator(String string) throws FileExistsException {
        try {
            File file = new File(string);
            if (Globals.noOverwrite && file.exists()) {
                throw new FileExistsException(string);
            }
            this.out = new PrintWriter(new FileOutputStream(file));
            this.plainPrinter = new Printer(this.out, this.spc);
        }
        catch (IOException iOException) {
            Errors.hardErr(iOException);
        }
    }

    private String addNodeString(String string, String string2) {
        return "{ " + string + ".addNode(" + string2 + "); }";
    }

    private String curVarName() {
        return "n" + String.valueOf(this.varNum++);
    }

    private void finalActions(VarInfo varInfo) {
        if (this.nestLevel == 0) {
            this.outerVars.addElement(varInfo);
        } else {
            this.prevVar = varInfo;
            this.annotateNode = true;
        }
    }

    private void generateChoices(ExpansionChoices expansionChoices, String string) {
        int n = 0;
        this.out.println("(");
        this.spc.updateSpc(1);
        this.out.print(this.spc.spc);
        ++this.nestLevel;
        expansionChoices.f0.accept(this);
        --this.nestLevel;
        if (!this.annotateNode) {
            Errors.softErr("Empty NodeChoice in " + this.curProduction + "()");
        } else {
            this.out.println("{ " + string + " = new NodeChoice(" + this.prevVar.getName() + ", " + String.valueOf(n) + "); }");
            ++n;
        }
        Enumeration enumeration = expansionChoices.f1.elements();
        while (enumeration.hasMoreElements()) {
            NodeSequence nodeSequence = (NodeSequence)enumeration.nextElement();
            ++this.nestLevel;
            this.spc.updateSpc(-1);
            this.out.println(String.valueOf(this.spc.spc) + nodeSequence.elementAt(0));
            this.spc.updateSpc(1);
            this.out.print(this.spc.spc);
            nodeSequence.elementAt(1).accept(this);
            --this.nestLevel;
            if (!this.annotateNode) {
                Errors.softErr("Empty NodeChoice in " + this.curProduction + "()");
                continue;
            }
            this.out.println("{ " + string + " = new NodeChoice(" + this.prevVar.getName() + ", " + String.valueOf(n) + "); }");
            ++n;
        }
        this.spc.updateSpc(-1);
        this.out.print(String.valueOf(this.spc.spc) + ")");
    }

    private String generateRHS(BNFProduction bNFProduction) {
        PrintWriter printWriter = this.out;
        StringWriter stringWriter = new StringWriter();
        this.out = new PrintWriter(stringWriter);
        this.plainPrinter.setOut(this.out);
        this.out.println(bNFProduction.f5);
        this.spc.updateSpc(1);
        this.out.print(this.spc.spc);
        bNFProduction.f6.accept(this);
        this.out.println();
        this.out.print(String.valueOf(this.spc.spc) + "{ return new " + bNFProduction.f1 + "(");
        Enumeration enumeration = this.outerVars.elements();
        if (enumeration.hasMoreElements()) {
            this.out.print(((VarInfo)enumeration.nextElement()).getName());
            while (enumeration.hasMoreElements()) {
                this.out.print("," + ((VarInfo)enumeration.nextElement()).getName());
            }
        }
        this.out.println("); }");
        this.spc.updateSpc(-1);
        this.out.print(String.valueOf(this.spc.spc) + bNFProduction.f7);
        this.out.flush();
        this.out.close();
        this.out = printWriter;
        this.plainPrinter.setOut(this.out);
        return stringWriter.toString();
    }

    private void generateSequence(Expansion expansion, String string) {
        Enumeration enumeration = expansion.f0.elements();
        if (!enumeration.hasMoreElements()) {
            Errors.warning("Generating empty NodeSequence in " + this.curProduction + "()");
            this.out.println("{ " + string + " = new NodeSequence(); }");
            this.out.print(this.spc.spc);
        } else {
            ExpansionUnit expansionUnit = (ExpansionUnit)enumeration.nextElement();
            String string2 = Integer.toString(expansion.f0.size());
            if (expansionUnit.f0.which == 0) {
                expansionUnit.accept(this);
                this.out.println("{ " + string + " = new NodeSequence(" + string2 + "); }");
                this.out.print(this.spc.spc);
            } else {
                this.out.println("{ " + string + " = new NodeSequence(" + string2 + "); }");
                this.out.print(this.spc.spc);
                ++this.nestLevel;
                expansionUnit.accept(this);
                --this.nestLevel;
                if (this.annotateNode) {
                    this.out.println(this.addNodeString(string, this.prevVar.getName()));
                    this.out.print(this.spc.spc);
                }
            }
            while (enumeration.hasMoreElements()) {
                ++this.nestLevel;
                ((Node)enumeration.nextElement()).accept(this);
                --this.nestLevel;
                if (!this.annotateNode) continue;
                this.out.println(this.addNodeString(string, this.prevVar.getName()));
                this.out.print(this.spc.spc);
            }
        }
    }

    private void generateSpecial(ExpansionUnit expansionUnit, String string) {
        NodeSequence nodeSequence = (NodeSequence)expansionUnit.f0.choice;
        ExpansionChoices expansionChoices = (ExpansionChoices)nodeSequence.elementAt(1);
        PrintWriter printWriter = this.out;
        StringWriter stringWriter = new StringWriter();
        this.out = new PrintWriter(stringWriter);
        this.plainPrinter.setOut(this.out);
        Vector vector = this.specialList;
        this.specialList = new Vector();
        ++this.nestLevel;
        expansionChoices.accept(this);
        --this.nestLevel;
        if (this.specialList.size() > 0) {
            Enumeration enumeration = this.specialList.elements();
            while (enumeration.hasMoreElements()) {
                VarInfo varInfo = (VarInfo)enumeration.nextElement();
                printWriter.println("{ " + varInfo.getName() + " = new " + varInfo.getType() + "(); }");
                printWriter.print(this.spc.spc);
            }
        }
        this.out.flush();
        this.out = printWriter;
        this.plainPrinter.setOut(this.out);
        this.specialList = vector;
        this.out.print(stringWriter.toString());
    }

    private VarInfo infoForMod(String string, String string2, boolean bl) {
        if (bl) {
            if (string2.equals("+")) {
                return new VarInfo("NodeList", string, "new NodeList()");
            }
            if (string2.equals("*")) {
                return new VarInfo("NodeListOptional", string, "new NodeListOptional()");
            }
            if (string2.equals("?")) {
                return new VarInfo("NodeOptional", string, "new NodeOptional()");
            }
            Errors.hardErr("Illegal EBNF modifier: " + string2);
        } else {
            if (string2.equals("+")) {
                return new VarInfo("NodeList", string);
            }
            if (string2.equals("*")) {
                return new VarInfo("NodeListOptional", string);
            }
            if (string2.equals("?")) {
                return new VarInfo("NodeOptional", string);
            }
            Errors.hardErr("Illegal EBNF modifier: " + string2);
        }
        return null;
    }

    private void parenExprCode(ExpansionUnit expansionUnit) {
        NodeSequence nodeSequence = (NodeSequence)expansionUnit.f0.choice;
        ExpansionChoices expansionChoices = (ExpansionChoices)nodeSequence.elementAt(1);
        this.out.println(nodeSequence.elementAt(0));
        this.spc.updateSpc(1);
        this.out.print(this.spc.spc);
        if (!((NodeOptional)nodeSequence.elementAt(3)).present()) {
            if (expansionChoices.f1.present()) {
                expansionChoices.accept(this);
            } else {
                ExpansionUnitTypeCounter expansionUnitTypeCounter = new ExpansionUnitTypeCounter();
                expansionChoices.accept(expansionUnitTypeCounter);
                if (expansionUnitTypeCounter.getNumNormals() == 0) {
                    Errors.warning("Empty parentheses in " + this.curProduction + "()", ((NodeToken)nodeSequence.elementAt((int)0)).beginLine);
                }
                String string = this.curVarName();
                VarInfo varInfo = new VarInfo("NodeSequence", string);
                this.varList.addElement(varInfo);
                this.generateSequence(expansionChoices.f0, string);
                this.finalActions(varInfo);
            }
            this.out.println();
            this.spc.updateSpc(-1);
            this.out.print(this.spc.spc);
            nodeSequence.elementAt(2).accept(this.plainPrinter);
            nodeSequence.elementAt(3).accept(this.plainPrinter);
            this.out.println();
        } else {
            String string = ((NodeChoice)((NodeOptional)nodeSequence.elementAt((int)3)).node).choice.toString();
            String string2 = this.curVarName();
            NodeListOptional nodeListOptional = expansionChoices.f0.f0;
            ExpansionUnitTypeCounter expansionUnitTypeCounter = new ExpansionUnitTypeCounter();
            expansionChoices.accept(expansionUnitTypeCounter);
            if (!nodeListOptional.present() || expansionUnitTypeCounter.getNumNormals() == 0) {
                Errors.softErr("Empty EBNF expansion in " + this.curProduction + "()", ((NodeToken)nodeSequence.elementAt((int)0)).beginLine);
            } else {
                VarInfo varInfo;
                ExpansionUnit expansionUnit2 = (ExpansionUnit)nodeListOptional.nodes.elementAt(0);
                if (this.specialList == null) {
                    varInfo = this.infoForMod(string2, string, true);
                } else {
                    varInfo = this.infoForMod(string2, string, false);
                    this.specialList.addElement(varInfo);
                }
                this.varList.addElement(varInfo);
                if (expansionChoices.f1.present() || expansionUnit2.f0.which != 0) {
                    this.generateSpecial(expansionUnit, string2);
                } else {
                    Vector vector = nodeListOptional.nodes;
                    expansionUnit2.accept(this.plainPrinter);
                    this.out.println();
                    this.out.print(this.spc.spc);
                    vector.removeElementAt(0);
                    this.generateSpecial(expansionUnit, string2);
                    vector.insertElementAt(expansionUnit2, 0);
                }
                if (this.annotateNode) {
                    this.out.print(this.addNodeString(string2, this.prevVar.getName()));
                }
                this.finalActions(varInfo);
            }
            this.out.println();
            this.spc.updateSpc(-1);
            this.out.print(this.spc.spc);
            nodeSequence.elementAt(2).accept(this.plainPrinter);
            nodeSequence.elementAt(3).accept(this.plainPrinter);
            this.out.println();
            if (((NodeOptional)nodeSequence.elementAt(3)).present() && (string.equals("*") || string.equals("+"))) {
                this.out.println(String.valueOf(this.spc.spc) + "{ " + string2 + ".nodes.trimToSize(); }");
            }
        }
        this.out.print(this.spc.spc);
    }

    private void resetVarNum() {
        this.varNum = 0;
    }

    public void visit(BNFProduction bNFProduction) {
        this.curProduction = bNFProduction.f1.toString();
        this.out.println(String.valueOf(String.valueOf(bNFProduction.f1)) + " " + bNFProduction.f1 + this.javaString(bNFProduction.f2) + " " + bNFProduction.f3);
        this.varList = new Vector();
        this.outerVars = new Vector();
        this.prevVar = null;
        this.resetVarNum();
        this.nestLevel = 0;
        this.annotateNode = true;
        String string = this.generateRHS(bNFProduction);
        this.out.println(String.valueOf(this.spc.spc) + "{");
        this.spc.updateSpc(1);
        Enumeration enumeration = this.varList.elements();
        while (enumeration.hasMoreElements()) {
            this.out.println(String.valueOf(this.spc.spc) + ((VarInfo)enumeration.nextElement()).getVarDeclString());
        }
        this.out.println();
        this.out.println(String.valueOf(this.spc.spc) + this.javaString(bNFProduction.f4));
        this.spc.updateSpc(-1);
        this.out.println(String.valueOf(this.spc.spc) + "}");
        this.out.print(String.valueOf(this.spc.spc) + string);
    }

    public void visit(Expansion expansion) {
        if (this.nestLevel == 0) {
            expansion.f0.accept(this);
        } else {
            ExpansionUnitTypeCounter expansionUnitTypeCounter = new ExpansionUnitTypeCounter();
            expansion.accept(expansionUnitTypeCounter);
            if (expansionUnitTypeCounter.getNumNormals() == 0) {
                this.annotateNode = false;
            } else if (expansionUnitTypeCounter.getNumNormals() == 1) {
                expansion.f0.accept(this);
                this.annotateNode = true;
            } else {
                String string = this.curVarName();
                VarInfo varInfo = new VarInfo("NodeSequence", string);
                this.varList.addElement(varInfo);
                this.generateSequence(expansion, string);
                this.prevVar = varInfo;
                this.annotateNode = true;
            }
        }
    }

    public void visit(ExpansionChoices expansionChoices) {
        if (!expansionChoices.f1.present()) {
            expansionChoices.f0.accept(this);
        } else {
            String string = this.curVarName();
            VarInfo varInfo = new VarInfo("NodeChoice", string);
            this.varList.addElement(varInfo);
            this.generateChoices(expansionChoices, string);
            this.out.println();
            this.out.print(this.spc.spc);
            this.finalActions(varInfo);
        }
    }

    public void visit(ExpansionUnit expansionUnit) {
        switch (expansionUnit.f0.which) {
            case 0: 
            case 1: {
                expansionUnit.accept(this.plainPrinter);
                this.out.println();
                this.out.print(this.spc.spc);
                this.annotateNode = false;
                break;
            }
            case 2: {
                this.parenExprCode(expansionUnit);
                break;
            }
            case 3: {
                NodeOptional nodeOptional = new NodeOptional();
                NodeSequence nodeSequence = new NodeSequence(4);
                NodeSequence nodeSequence2 = (NodeSequence)expansionUnit.f0.choice;
                nodeSequence.addNode(new NodeToken("("));
                nodeSequence.addNode((ExpansionChoices)nodeSequence2.elementAt(1));
                nodeSequence.addNode(new NodeToken(")"));
                NodeChoice nodeChoice = new NodeChoice(new NodeToken("?"), 2);
                nodeOptional.addNode(nodeChoice);
                nodeSequence.addNode(nodeOptional);
                NodeChoice nodeChoice2 = new NodeChoice(nodeSequence, 2);
                this.parenExprCode(new ExpansionUnit(nodeChoice2));
                break;
            }
            case 4: {
                NodeSequence nodeSequence = (NodeSequence)expansionUnit.f0.choice;
                NodeOptional nodeOptional = (NodeOptional)nodeSequence.elementAt(0);
                if (nodeOptional.present()) {
                    NodeSequence nodeSequence3 = (NodeSequence)nodeOptional.node;
                    this.out.print(String.valueOf(this.javaString(nodeSequence3.elementAt(0))) + nodeSequence3.elementAt(1));
                }
                nodeSequence.elementAt(1).accept(this);
                break;
            }
            default: {
                Errors.hardErr("n.f0.which = " + String.valueOf(expansionUnit.f0.which));
            }
        }
    }

    public void visit(ExpansionUnitTerm expansionUnitTerm) {
        if (expansionUnitTerm.f0.which == 0) {
            expansionUnitTerm.f0.accept(this);
        } else {
            NodeSequence nodeSequence = (NodeSequence)expansionUnitTerm.f0.choice;
            String string = this.curVarName();
            VarInfo varInfo = new VarInfo(nodeSequence.elementAt(0).toString(), string);
            this.varList.addElement(varInfo);
            this.out.print(String.valueOf(string) + "=");
            nodeSequence.elementAt(0).accept(this.plainPrinter);
            nodeSequence.elementAt(1).accept(this.plainPrinter);
            this.out.println();
            this.out.print(this.spc.spc);
            this.finalActions(varInfo);
        }
    }

    public void visit(JavaCCInput javaCCInput) {
        this.out.println(String.valueOf(this.spc.spc) + Globals.fileHeader(this.spc));
        this.out.println();
        this.out.print(this.spc.spc);
        javaCCInput.f0.accept(this.plainPrinter);
        this.out.println("\n");
        this.out.println(String.valueOf(this.spc.spc) + javaCCInput.f1 + javaCCInput.f2 + javaCCInput.f3 + javaCCInput.f4);
        this.out.println(String.valueOf(this.spc.spc) + ImportInserter.unitAddImport(javaCCInput.f5));
        this.out.println(String.valueOf(this.spc.spc) + javaCCInput.f6 + javaCCInput.f7 + javaCCInput.f8 + javaCCInput.f9 + "\n");
        this.out.print(this.spc.spc);
        this.visit(javaCCInput.f10, "\n\n" + this.spc.spc);
        this.out.println();
        this.flushWriter();
    }

    public void visit(JavaCodeProduction javaCodeProduction) {
        javaCodeProduction.accept(this.plainPrinter);
    }

    public void visit(LocalLookahead localLookahead) {
        localLookahead.accept(this.plainPrinter);
    }

    public void visit(RegularExprProduction regularExprProduction) {
        regularExprProduction.accept(this.plainPrinter);
    }

    public void visit(RegularExpression regularExpression) {
        String string = this.curVarName();
        String string2 = this.curVarName();
        VarInfo varInfo = new VarInfo("NodeToken", string);
        VarInfo varInfo2 = new VarInfo("Token", string2);
        this.varList.addElement(varInfo);
        this.varList.addElement(varInfo2);
        this.out.print(String.valueOf(string2) + "=");
        regularExpression.f0.accept(this.plainPrinter);
        if (regularExpression.f0.which == 3) {
            this.out.println(" { ");
            this.spc.updateSpc(1);
            this.out.println(String.valueOf(this.spc.spc) + string2 + ".beginColumn++; " + string2 + ".endColumn++;");
            this.out.println(String.valueOf(this.spc.spc) + string + " = JTBToolkit.makeNodeToken(" + string2 + ");");
            this.spc.updateSpc(-1);
            this.out.println(String.valueOf(this.spc.spc) + "}");
        } else {
            this.out.println(" { " + string + " = JTBToolkit.makeNodeToken(" + string2 + "); }");
        }
        this.out.print(this.spc.spc);
        this.finalActions(varInfo);
    }
}

