/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.jtb;

import EDU.purdue.jtb.InvalidCommandLineException;
import EDU.purdue.jtb.misc.Errors;
import EDU.purdue.jtb.misc.FileExistsException;
import EDU.purdue.jtb.misc.FileGenerator;
import EDU.purdue.jtb.misc.Globals;
import EDU.purdue.jtb.misc.OldFileGenerator;
import EDU.purdue.jtb.misc.toolkit.DepthFirstVisitorBuilder;
import EDU.purdue.jtb.misc.toolkit.OldDepthFirstVisitorBuilder;
import EDU.purdue.jtb.misc.toolkit.SchemeRecordBuilder;
import EDU.purdue.jtb.misc.toolkit.SchemeSemanticChecker;
import EDU.purdue.jtb.misc.toolkit.SchemeVisitorBuilder;
import EDU.purdue.jtb.misc.toolkit.TreeDumperBuilder;
import EDU.purdue.jtb.misc.toolkit.TreeFormatterBuilder;
import EDU.purdue.jtb.parser.JTBParser;
import EDU.purdue.jtb.parser.ParseException;
import EDU.purdue.jtb.syntaxtree.JavaCCInput;
import EDU.purdue.jtb.visitor.Annotator;
import EDU.purdue.jtb.visitor.ClassGenerator;
import EDU.purdue.jtb.visitor.Printer;
import EDU.purdue.jtb.visitor.SemanticChecker;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Vector;

public class JTB {
    private static InputStream in;
    private static String progName;
    private static String version;
    private static String scriptName;

    static {
        progName = "JTB";
        version = "1.2.2";
        scriptName = "jtb";
    }

    public static void main(String[] stringArray) {
        block41: {
            try {
                if (!JTB.processCommandLine(stringArray)) {
                    return;
                }
            }
            catch (InvalidCommandLineException invalidCommandLineException) {
                System.err.println(String.valueOf(progName) + ":  " + invalidCommandLineException.getMessage());
                return;
            }
            catch (Exception exception) {
                Errors.hardErr(exception.getMessage());
            }
            System.err.println(String.valueOf(progName) + " version " + version);
            System.err.println(String.valueOf(progName) + ":  Reading from " + Globals.inFilename + "...");
            JTBParser jTBParser = new JTBParser(in);
            try {
                JavaCCInput javaCCInput = JTBParser.JavaCCInput();
                System.err.println(String.valueOf(progName) + ":  Input file parsed successfully.");
                ClassGenerator classGenerator = new ClassGenerator();
                FileGenerator fileGenerator = null;
                Errors.resetCounts();
                if (!Globals.noSemanticCheck) {
                    javaCCInput.accept(new SemanticChecker());
                    if (Errors.errorCount() > 0) {
                        Errors.printSummary();
                        return;
                    }
                }
                javaCCInput.accept(classGenerator);
                Vector vector = classGenerator.getClassList();
                if (Errors.errorCount() > 0) {
                    Errors.printSummary();
                    return;
                }
                if (Globals.printGrammarToOut) {
                    javaCCInput.accept(new Printer(System.out));
                }
                if (Globals.printClassList) {
                    fileGenerator = new FileGenerator(vector);
                    System.out.println("\nThe classes generated and the fields each contains are as follows:\n");
                    fileGenerator.printClassList(new PrintWriter(System.out, true));
                }
                if (!Globals.generateFiles) break block41;
                try {
                    javaCCInput.accept(new Annotator());
                    if (Errors.errorCount() > 0) {
                        Errors.printSummary();
                        return;
                    }
                    System.err.println(String.valueOf(progName) + ":  \"" + Globals.outFilename + "\" generated to current directory.");
                }
                catch (FileExistsException fileExistsException) {
                    System.err.println(String.valueOf(progName) + ":  \"" + Globals.outFilename + "\" already exists.  Won't overwrite.");
                }
                if (fileGenerator == null) {
                    fileGenerator = new FileGenerator(vector);
                    if (Errors.errorCount() > 0) {
                        Errors.printSummary();
                        return;
                    }
                }
                try {
                    fileGenerator.generateAutoClassFiles();
                }
                catch (FileExistsException fileExistsException) {
                    System.err.println(String.valueOf(progName) + ":  One or more of the automatic " + "node class files already exists.  Won't overwrite.");
                }
                try {
                    fileGenerator.generateClassFiles();
                    System.err.println(String.valueOf(progName) + ":  Syntax tree Java source " + "files generated to directory \"" + Globals.nodeDir + "\".");
                }
                catch (FileExistsException fileExistsException) {
                    System.err.println(String.valueOf(progName) + ":  One or more of the generated " + "node class files already exists.  Won't overwrite.");
                }
                try {
                    fileGenerator.generateVisitorFile();
                    System.err.println(String.valueOf(progName) + ":  \"" + "ObjectVisitor" + ".java\" generated " + "to directory \"" + Globals.visitorDir + "\".");
                }
                catch (FileExistsException fileExistsException) {
                    System.err.println(String.valueOf(progName) + ":  \"" + "ObjectVisitor" + "\" already exists.  Won't overwrite.");
                }
                try {
                    new OldFileGenerator(vector).generateVisitorFile();
                    System.err.println(String.valueOf(progName) + ":  \"" + "Visitor" + ".java\" generated " + "to directory \"" + Globals.visitorDir + "\".");
                }
                catch (FileExistsException fileExistsException) {
                    System.err.println(String.valueOf(progName) + ":  \"" + "Visitor" + "\" already exists.  Won't overwrite.");
                }
                try {
                    new DepthFirstVisitorBuilder(vector).generateDepthFirstVisitor();
                    System.err.println(String.valueOf(progName) + ":  \"" + "ObjectDepthFirst.java" + "\" " + "generated to directory \"" + Globals.visitorDir + "\".");
                }
                catch (FileExistsException fileExistsException) {
                    System.err.println(String.valueOf(progName) + ":  \"" + "ObjectDepthFirst.java" + "\" already exists.  " + "Won't overwrite.");
                }
                try {
                    new OldDepthFirstVisitorBuilder(vector).generateDepthFirstVisitor();
                    System.err.println(String.valueOf(progName) + ":  \"" + "DepthFirstVisitor.java" + "\" " + "generated to directory \"" + Globals.visitorDir + "\".");
                }
                catch (FileExistsException fileExistsException) {
                    System.err.println(String.valueOf(progName) + ":  \"" + "DepthFirstVisitor.java" + "\" already exists.  " + "Won't overwrite.");
                }
                if (Globals.schemeToolkit) {
                    javaCCInput.accept(new SchemeSemanticChecker());
                    if (Errors.errorCount() > 0) {
                        Errors.printSummary();
                        return;
                    }
                    try {
                        new SchemeVisitorBuilder(vector).generateSchemeBuilder();
                        System.err.println(String.valueOf(progName) + ":  \"" + "SchemeTreeBuilder.java" + "\" generated to " + "directory \"" + Globals.visitorDir + "\".");
                    }
                    catch (FileExistsException fileExistsException) {
                        System.err.println(String.valueOf(progName) + ":  \"" + "SchemeTreeBuilder.java" + "\" already exists.  " + "Won't overwrite.");
                    }
                    try {
                        new SchemeRecordBuilder(vector).generateSchemeRecords();
                        System.err.println(String.valueOf(progName) + ":  \"" + "records.scm" + "\" generated to " + "current directory.");
                    }
                    catch (FileExistsException fileExistsException) {
                        System.err.println(String.valueOf(progName) + ":  \"" + "records.scm" + "\" already exists.  " + "Won't overwrite.");
                    }
                }
                if (Globals.printerToolkit) {
                    try {
                        new TreeDumperBuilder().generateTreeDumper();
                        System.err.println(String.valueOf(progName) + ":  \"" + "TreeDumper.java" + "\" generated to " + "directory \"" + Globals.visitorDir + "\".");
                    }
                    catch (FileExistsException fileExistsException) {
                        System.err.println(String.valueOf(progName) + ":  \"" + "TreeDumper.java" + "\" already exists.  " + "Won't overwrite.");
                    }
                    try {
                        new TreeFormatterBuilder(vector).generateTreeFormatter();
                        System.err.println(String.valueOf(progName) + ":  \"" + "TreeFormatter.java" + "\" generated to " + "directory \"" + Globals.visitorDir + "\".");
                    }
                    catch (FileExistsException fileExistsException) {
                        System.err.println(String.valueOf(progName) + ":  \"" + "TreeFormatter.java" + "\" already exists.  " + "Won't overwrite.");
                    }
                }
                if (Errors.errorCount() > 0 || Errors.warningCount() > 0) {
                    Errors.printSummary();
                }
            }
            catch (ParseException parseException) {
                System.err.println("\n" + parseException.getMessage() + "\n");
                System.err.println(String.valueOf(progName) + ":  Encountered errors during " + "parse.");
            }
            catch (Exception exception) {
                Errors.hardErr(exception);
            }
        }
    }

    private static void printHelp() {
        System.out.print(String.valueOf(progName) + " version " + version + "\n" + "\n" + "Usage: " + scriptName + " [OPTIONS] " + "[inputfile]\n" + "\n" + "Standard options:\n" + "  -h          Displays this help message.\n" + "  -o NAME     Uses NAME as the filename for the annotated output grammar.\n" + "  -np NAME    Uses NAME as the package for the syntax tree nodes.\n" + "  -vp NAME    Uses NAME as the package for the default Visitor class.\n" + "  -p NAME     \"-p pkg\" is short for \"-np pkg.syntaxtree -vp pkg.visitor\"\n" + "  -si         Read from standard input rather than a file.\n" + "  -w          Do not overwrite existing files.\n" + "  -e          Suppress JTB semantic error checking.\n" + "  -jd         Generate JavaDoc-friendly comments in the nodes and visitor.\n" + "  -f          Use descriptive node class field names.\n" + "  -ns NAME    Uses NAME as the class which all node classes will extend.\n" + "  -pp         Generate parent pointers in all node classes.\n" + "  -tk         Generate special tokens into the tree.\n" + "  -r          Generate ObjectDepthFirst with alternative return channels.\n" + "\n" + "Toolkit options:\n" + "  -scheme     Generate: (1) Scheme records representing the grammar.\n" + "                        (2) A Scheme tree building visitor.\n" + "  -printer    Generate a syntax tree dumping visitor.\n" + "\n");
    }

    private static boolean processCommandLine(String[] stringArray) throws InvalidCommandLineException {
        boolean bl = false;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].charAt(0) != '-') {
                if (bl) {
                    bl = false;
                    break;
                }
                try {
                    in = new FileInputStream(stringArray[n]);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.println(String.valueOf(progName) + ":  File \"" + stringArray[n] + "\" not found.");
                    return false;
                }
                Globals.inFilename = stringArray[n];
                bl = true;
            } else {
                if (stringArray[n].length() <= 1) {
                    throw new InvalidCommandLineException("Unknown option \"" + stringArray[n] + "\".  Try \"" + scriptName + " -h\" for more " + "information.");
                }
                if (stringArray[n].equals("-h")) {
                    bl = false;
                    break;
                }
                if (stringArray[n].equals("-o")) {
                    if (++n >= stringArray.length || stringArray[n].charAt(0) == '-') {
                        throw new InvalidCommandLineException("Option \"-o\" must be followed by a filename.");
                    }
                    Globals.outFilename = stringArray[n];
                } else if (stringArray[n].equals("-np")) {
                    if (++n >= stringArray.length || stringArray[n].charAt(0) == '-') {
                        throw new InvalidCommandLineException("Option \"-np\" must be followed by a package name.");
                    }
                    Globals.setNodePackage(stringArray[n]);
                } else if (stringArray[n].equals("-vp")) {
                    if (++n >= stringArray.length || stringArray[n].charAt(0) == '-') {
                        throw new InvalidCommandLineException("Option \"-vp\" must be followed by a package name.");
                    }
                    Globals.setVisitorPackage(stringArray[n]);
                } else if (stringArray[n].equals("-p")) {
                    if (++n >= stringArray.length || stringArray[n].charAt(0) == '-') {
                        throw new InvalidCommandLineException("Option \"-p\" must be followed by a package name.");
                    }
                    Globals.setNodePackage(String.valueOf(stringArray[n]) + ".syntaxtree");
                    Globals.setVisitorPackage(String.valueOf(stringArray[n]) + ".visitor");
                } else if (stringArray[n].equals("-si")) {
                    in = System.in;
                    Globals.inFilename = "standard input";
                    bl = true;
                } else if (stringArray[n].equals("-w")) {
                    Globals.noOverwrite = true;
                } else if (stringArray[n].equals("-e")) {
                    Globals.noSemanticCheck = true;
                } else if (stringArray[n].equals("-jd")) {
                    Globals.javaDocComments = true;
                } else if (stringArray[n].equals("-f")) {
                    Globals.descriptiveFieldNames = true;
                } else if (stringArray[n].equals("-ns")) {
                    if (++n >= stringArray.length || stringArray[n].charAt(0) == '-') {
                        throw new InvalidCommandLineException("Option \"-ns\" must be followed by a class name.");
                    }
                    Globals.nodeSuperclass = stringArray[n];
                } else if (stringArray[n].equals("-pp")) {
                    Globals.parentPointers = true;
                } else if (stringArray[n].equals("-tk")) {
                    Globals.keepSpecialTokens = true;
                } else if (stringArray[n].equals("-r")) {
                    Globals.arguRet = true;
                } else if (stringArray[n].equals("-scheme")) {
                    Globals.schemeToolkit = true;
                } else if (stringArray[n].equals("-printer")) {
                    Globals.printerToolkit = true;
                } else if (stringArray[n].equals("-cl")) {
                    Globals.printClassList = true;
                } else if (stringArray[n].equals("-no")) {
                    Globals.generateFiles = false;
                } else if (stringArray[n].equals("-g")) {
                    Globals.printGrammarToOut = true;
                } else {
                    throw new InvalidCommandLineException("Unknown option \"" + stringArray[n] + "\".  Try \"" + scriptName + " -h\" for more " + "information.");
                }
            }
            ++n;
        }
        if (bl) {
            return true;
        }
        JTB.printHelp();
        return false;
    }
}

