/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.jtb.misc;

import EDU.purdue.jtb.misc.Globals;

public class Errors {
    private static int numErrors = 0;
    private static int numWarnings = 0;

    public static int errorCount() {
        return numErrors;
    }

    public static void hardErr(String string) {
        System.err.println(String.valueOf(Globals.inFilename) + ":  unexpected program error:  " + string);
        System.err.println();
        System.err.println("Please report this to wanjun@purdue.edu");
        System.err.println();
        try {
            throw new Exception();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println();
            System.exit(-1);
            return;
        }
    }

    public static void hardErr(Throwable throwable) {
        System.err.println(String.valueOf(Globals.inFilename) + ":  unexpected program error:  " + throwable.getMessage());
        System.err.println();
        System.err.println("Please report this to wanjun@purdue.edu");
        System.err.println();
        throwable.printStackTrace();
        System.exit(-1);
    }

    public static void notice(String string) {
        System.err.println(String.valueOf(Globals.inFilename) + ":  " + string);
    }

    public static void printSummary() {
        System.err.println(String.valueOf(numWarnings) + " warnings, " + numErrors + " errors.");
    }

    public static void resetCounts() {
        numWarnings = 0;
        numErrors = 0;
    }

    public static void setErrorCount(int n) {
        numErrors = n;
    }

    public static void setWarningCount(int n) {
        numWarnings = n;
    }

    public static void softErr(String string) {
        Errors.softErr(string, -1);
    }

    public static void softErr(String string, int n) {
        if (n == -1) {
            System.err.println(String.valueOf(Globals.inFilename) + ":  warning:  " + string);
        } else {
            System.err.println(String.valueOf(Globals.inFilename) + " (" + Integer.toString(n) + "):  " + string);
        }
        ++numErrors;
    }

    public static void warning(String string) {
        Errors.warning(string, -1);
    }

    public static void warning(String string, int n) {
        if (n == -1) {
            System.err.println(String.valueOf(Globals.inFilename) + ":  warning:  " + string);
        } else {
            System.err.println(String.valueOf(Globals.inFilename) + " (" + Integer.toString(n) + "):  warning:  " + string);
        }
        ++numWarnings;
    }

    public static int warningCount() {
        return numWarnings;
    }
}

