/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.jtb.misc;

import EDU.purdue.jtb.misc.Errors;
import EDU.purdue.jtb.misc.Globals;
import java.util.Hashtable;

public class FieldNameGenerator {
    private int fieldNum = 0;
    private Hashtable nameTable;

    public FieldNameGenerator() {
        if (Globals.descriptiveFieldNames) {
            this.nameTable = new Hashtable();
        }
    }

    public String curFieldName(String string) {
        if (!Globals.descriptiveFieldNames) {
            return "f" + String.valueOf(this.fieldNum++);
        }
        String string2 = this.varNameForClass(string);
        Integer n = (Integer)this.nameTable.get(string2);
        if (n == null) {
            n = new Integer(0);
            this.nameTable.put(string2, n);
            return string2;
        }
        n = new Integer(n + 1);
        this.nameTable.put(string2, n);
        return String.valueOf(string2) + n.toString();
    }

    public String getNameForMod(String string) {
        if (string.equals("+")) {
            return "NodeList";
        }
        if (string.equals("*")) {
            return "NodeListOptional";
        }
        if (string.equals("?")) {
            return "NodeOptional";
        }
        Errors.hardErr("Illegal EBNF modifier in ExpansionUnit: mod = " + string);
        return "";
    }

    public void resetFieldNum() {
        this.fieldNum = 0;
        if (Globals.descriptiveFieldNames) {
            this.nameTable.clear();
        }
    }

    public String varNameForClass(String string) {
        StringBuffer stringBuffer = new StringBuffer(String.valueOf(Character.toLowerCase(string.charAt(0))));
        stringBuffer.append(string.substring(1, string.length()));
        return stringBuffer.toString();
    }
}

