/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.jtb.misc;

import EDU.purdue.jtb.misc.AutoClasses;
import EDU.purdue.jtb.misc.ClassInfo;
import EDU.purdue.jtb.misc.Errors;
import EDU.purdue.jtb.misc.FileExistsException;
import EDU.purdue.jtb.misc.Globals;
import EDU.purdue.jtb.misc.Spacing;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class FileGenerator {
    public static final int INDENT_AMT = 3;
    private Vector classList;
    private File nodeDir;
    private File visitorDir;

    public FileGenerator(Vector vector) {
        this.classList = vector;
        this.nodeDir = new File(Globals.nodeDir);
        this.visitorDir = new File(Globals.visitorDir);
        if (!this.nodeDir.exists()) {
            this.nodeDir.mkdir();
        } else if (!this.nodeDir.isDirectory()) {
            Errors.softErr("\"" + Globals.nodeDir + "\" exists but is not a " + "directory.");
        }
        if (!this.visitorDir.exists()) {
            this.visitorDir.mkdir();
        } else if (!this.visitorDir.isDirectory()) {
            Errors.softErr("\"" + Globals.visitorDir + "\" exists but is not a " + "directory.");
        }
    }

    public void generateAutoClassFiles() throws FileExistsException {
        try {
            boolean bl = true;
            bl = bl && this.printStringToFile("Node.java", AutoClasses.getNodeClassStr());
            bl = bl && this.printStringToFile("NodeListInterface.java", AutoClasses.getNodeListInterfaceClassStr());
            bl = bl && this.printStringToFile("NodeChoice.java", AutoClasses.getNodeChoiceClassStr());
            bl = bl && this.printStringToFile("NodeList.java", AutoClasses.getNodeListClassStr());
            bl = bl && this.printStringToFile("NodeListOptional.java", AutoClasses.getNodeListOptionalClassStr());
            bl = bl && this.printStringToFile("NodeOptional.java", AutoClasses.getNodeOptionalClassStr());
            bl = bl && this.printStringToFile("NodeSequence.java", AutoClasses.getNodeSequenceClassStr());
            boolean bl2 = bl = bl && this.printStringToFile("NodeToken.java", AutoClasses.getNodeTokenClassStr());
            if (Globals.noOverwrite && !bl) {
                throw new FileExistsException("one of the automatic node classes");
            }
        }
        catch (IOException iOException) {
            Errors.hardErr(iOException);
        }
    }

    public void generateClassFiles() throws FileExistsException {
        try {
            boolean bl = false;
            Spacing spacing = new Spacing(3);
            Enumeration enumeration = this.classList.elements();
            while (enumeration.hasMoreElements()) {
                ClassInfo classInfo = (ClassInfo)enumeration.nextElement();
                File file = new File(this.nodeDir, String.valueOf(classInfo.getName()) + ".java");
                if (Globals.noOverwrite && file.exists()) {
                    bl = true;
                    break;
                }
                PrintWriter printWriter = new PrintWriter(new FileOutputStream(file), false);
                printWriter.println(String.valueOf(spacing.spc) + Globals.fileHeader(spacing));
                printWriter.println();
                printWriter.println(String.valueOf(spacing.spc) + "package " + Globals.nodePackage + ";");
                printWriter.println();
                printWriter.println(String.valueOf(spacing.spc) + "/**");
                printWriter.println(String.valueOf(spacing.spc) + " * Grammar production:");
                if (Globals.javaDocComments) {
                    printWriter.println(String.valueOf(spacing.spc) + " * <PRE>");
                }
                printWriter.println(String.valueOf(spacing.spc) + classInfo.getEbnfProduction(spacing));
                if (Globals.javaDocComments) {
                    printWriter.println(String.valueOf(spacing.spc) + " * </PRE>");
                }
                printWriter.println(String.valueOf(spacing.spc) + " */");
                printWriter.println(classInfo.getClassString(spacing));
                printWriter.flush();
                printWriter.close();
            }
            if (Globals.noOverwrite && bl) {
                throw new FileExistsException("one of the generated node classes");
            }
        }
        catch (IOException iOException) {
            Errors.hardErr(iOException);
        }
    }

    public void generateVisitorFile() throws FileExistsException {
        try {
            File file = new File(this.visitorDir, "ObjectVisitor.java");
            if (Globals.noOverwrite && file.exists()) {
                throw new FileExistsException("ObjectVisitor.java");
            }
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file), false);
            Spacing spacing = new Spacing(3);
            printWriter.println(Globals.fileHeader(spacing));
            printWriter.println();
            printWriter.println(String.valueOf(spacing.spc) + "package " + Globals.visitorPackage + ";");
            if (!Globals.visitorPackage.equals(Globals.nodePackage)) {
                printWriter.println(String.valueOf(spacing.spc) + "import " + Globals.nodePackage + ".*;");
            }
            printWriter.println(String.valueOf(spacing.spc) + "import java.util.*;\n");
            printWriter.println(String.valueOf(spacing.spc) + "/**");
            printWriter.println(String.valueOf(spacing.spc) + " * All Object visitors must implement this interface.");
            printWriter.println(String.valueOf(spacing.spc) + " */");
            printWriter.println(String.valueOf(spacing.spc) + "public interface " + "ObjectVisitor" + " {");
            this.printAutoVisitorMethods(printWriter);
            spacing.updateSpc(1);
            printWriter.println(String.valueOf(spacing.spc) + "//");
            printWriter.println(String.valueOf(spacing.spc) + "// User-generated visitor methods below");
            printWriter.println(String.valueOf(spacing.spc) + "//");
            printWriter.println();
            Enumeration enumeration = this.classList.elements();
            while (enumeration.hasMoreElements()) {
                ClassInfo classInfo = (ClassInfo)enumeration.nextElement();
                String string = classInfo.getName();
                printWriter.println(String.valueOf(spacing.spc) + "/**");
                if (Globals.javaDocComments) {
                    printWriter.println(String.valueOf(spacing.spc) + " * <PRE>");
                }
                printWriter.println(classInfo.getEbnfProduction(spacing));
                if (Globals.javaDocComments) {
                    printWriter.println(String.valueOf(spacing.spc) + " * </PRE>");
                }
                printWriter.println(String.valueOf(spacing.spc) + " */");
                printWriter.print(String.valueOf(spacing.spc) + "public Object visit");
                printWriter.println("(" + string + " n, Object argu);\n");
            }
            spacing.updateSpc(-1);
            printWriter.println(String.valueOf(spacing.spc) + "}");
            printWriter.flush();
            printWriter.close();
        }
        catch (IOException iOException) {
            Errors.hardErr(iOException);
        }
    }

    private void printAutoVisitorMethods(PrintWriter printWriter) {
        printWriter.println("   //");
        printWriter.println("   // Object Auto class visitors");
        printWriter.println("   //");
        printWriter.print(AutoClasses.getNodeListVisitorStr());
        printWriter.print(AutoClasses.getNodeListOptionalVisitorStr());
        printWriter.print(AutoClasses.getNodeOptionalVisitorStr());
        printWriter.print(AutoClasses.getNodeSequenceVisitorStr());
        printWriter.print(AutoClasses.getNodeTokenVisitorStr());
        printWriter.println();
    }

    public void printClassList(PrintWriter printWriter) {
        Spacing spacing = new Spacing(3);
        Enumeration enumeration = this.classList.elements();
        while (enumeration.hasMoreElements()) {
            ClassInfo classInfo = (ClassInfo)enumeration.nextElement();
            String string = classInfo.getName();
            printWriter.println(String.valueOf(spacing.spc) + "class " + string + ":");
            spacing.updateSpc(1);
            Enumeration enumeration2 = classInfo.getTypeList().elements();
            Enumeration enumeration3 = classInfo.getNameList().elements();
            while (enumeration2.hasMoreElements()) {
                printWriter.println(String.valueOf(spacing.spc) + (String)enumeration2.nextElement() + " " + (String)enumeration3.nextElement());
            }
            printWriter.println();
            spacing.updateSpc(-1);
        }
        printWriter.flush();
    }

    private boolean printStringToFile(String string, String string2) throws IOException {
        File file = new File(Globals.nodeDir, string);
        if (Globals.noOverwrite && file.exists()) {
            return false;
        }
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file), true);
        printWriter.println(Globals.fileHeader());
        printWriter.println();
        printWriter.println(string2);
        printWriter.close();
        return true;
    }
}

