/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.jtb.misc.toolkit;

import EDU.purdue.jtb.misc.ClassInfo;
import EDU.purdue.jtb.misc.Errors;
import EDU.purdue.jtb.misc.FileExistsException;
import EDU.purdue.jtb.misc.Globals;
import EDU.purdue.jtb.misc.Spacing;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class DepthFirstVisitorBuilder {
    public static final String visitorName = "ObjectDepthFirst";
    public static final String outFilename = "ObjectDepthFirst.java";
    public static final int INDENT_AMT = 3;
    private Vector classList;
    private File visitorDir;

    public DepthFirstVisitorBuilder(Vector vector) {
        this.classList = vector;
        this.visitorDir = new File(Globals.visitorDir);
        if (!this.visitorDir.exists()) {
            this.visitorDir.mkdir();
        }
    }

    public void generateDepthFirstVisitor() throws FileExistsException {
        try {
            File file = new File(this.visitorDir, outFilename);
            if (Globals.noOverwrite && file.exists()) {
                throw new FileExistsException(outFilename);
            }
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file), false);
            Spacing spacing = new Spacing(3);
            printWriter.println(Globals.fileHeader(spacing));
            printWriter.println();
            printWriter.println(String.valueOf(spacing.spc) + "package " + Globals.visitorPackage + ";");
            if (!Globals.visitorPackage.equals(Globals.nodePackage)) {
                printWriter.println(String.valueOf(spacing.spc) + "import " + Globals.nodePackage + ".*;");
            }
            printWriter.println(String.valueOf(spacing.spc) + "import java.util.*;\n");
            printWriter.println(String.valueOf(spacing.spc) + "/**");
            printWriter.println(String.valueOf(spacing.spc) + " * Provides default methods which visit each " + "node in the tree in depth-first");
            printWriter.println(String.valueOf(spacing.spc) + " * order.  Your visitors may extend this class.");
            printWriter.println(String.valueOf(spacing.spc) + " */");
            printWriter.println(String.valueOf(spacing.spc) + "public class " + visitorName + " implements " + "ObjectVisitor" + " {");
            this.printAutoVisitorMethods(printWriter);
            spacing.updateSpc(1);
            printWriter.println(String.valueOf(spacing.spc) + "//");
            printWriter.println(String.valueOf(spacing.spc) + "// User-generated visitor methods below");
            printWriter.println(String.valueOf(spacing.spc) + "//");
            printWriter.println();
            Enumeration enumeration = this.classList.elements();
            while (enumeration.hasMoreElements()) {
                Enumeration enumeration2;
                ClassInfo classInfo = (ClassInfo)enumeration.nextElement();
                String string = classInfo.getName();
                printWriter.println(String.valueOf(spacing.spc) + "/**");
                if (Globals.javaDocComments) {
                    printWriter.println(String.valueOf(spacing.spc) + " * <PRE>");
                }
                printWriter.println(classInfo.getEbnfProduction(spacing));
                if (Globals.javaDocComments) {
                    printWriter.println(String.valueOf(spacing.spc) + " * </PRE>");
                }
                printWriter.println(String.valueOf(spacing.spc) + " */");
                printWriter.print(String.valueOf(spacing.spc) + "public Object visit");
                printWriter.println("(" + string + " n, Object argu) {");
                spacing.updateSpc(1);
                if (Globals.arguRet) {
                    printWriter.println(String.valueOf(spacing.spc) + "Object _ret=argu;");
                    enumeration2 = classInfo.getNameList().elements();
                    while (enumeration2.hasMoreElements()) {
                        printWriter.println(String.valueOf(spacing.spc) + "_ret=n." + (String)enumeration2.nextElement() + ".accept(this, _ret);");
                    }
                } else {
                    printWriter.println(String.valueOf(spacing.spc) + "Object _ret=null;");
                    enumeration2 = classInfo.getNameList().elements();
                    while (enumeration2.hasMoreElements()) {
                        printWriter.println(String.valueOf(spacing.spc) + "n." + (String)enumeration2.nextElement() + ".accept(this, argu);");
                    }
                }
                printWriter.println(String.valueOf(spacing.spc) + "return _ret;");
                spacing.updateSpc(-1);
                printWriter.println(String.valueOf(spacing.spc) + "}\n");
            }
            spacing.updateSpc(-1);
            printWriter.println(String.valueOf(spacing.spc) + "}");
            printWriter.flush();
            printWriter.close();
        }
        catch (IOException iOException) {
            Errors.hardErr("Could not generate ObjectDepthFirst.java");
        }
    }

    static String getNodeListOptionalVisitorStr() {
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("   public Object visit(NodeListOptional n, Object argu) {\n");
        if (Globals.arguRet) {
            stringBuffer.append("      if ( n.present() ) {\n         Object _ret=argu;\n         int _count=0;\n         for ( Enumeration e = n.elements(); e.hasMoreElements(); ) {\n            _ret=((Node)e.nextElement()).accept(this,_ret);\n            _count++;\n         }\n         return _ret;\n      }\n      else\n         return argu;\n   }\n");
        } else {
            stringBuffer.append("      if ( n.present() ) {\n         Object _ret=null;\n         int _count=0;\n         for ( Enumeration e = n.elements(); e.hasMoreElements(); ) {\n            ((Node)e.nextElement()).accept(this,argu);\n            _count++;\n         }\n         return _ret;\n      }\n      else\n         return null;\n   }\n");
        }
        return stringBuffer.toString();
    }

    static String getNodeListVisitorStr() {
        StringBuffer stringBuffer = new StringBuffer(240);
        stringBuffer.append("   public Object visit(NodeList n, Object argu) {\n");
        if (Globals.arguRet) {
            stringBuffer.append("      Object _ret=argu;\n      int _count=0;\n      for ( Enumeration e = n.elements(); e.hasMoreElements(); ) {\n         _ret=((Node)e.nextElement()).accept(this,_ret);\n         _count++;\n      }\n      return _ret;\n   }\n");
        } else {
            stringBuffer.append("      Object _ret=null;\n      int _count=0;\n      for ( Enumeration e = n.elements(); e.hasMoreElements(); ) {\n         ((Node)e.nextElement()).accept(this,argu);\n         _count++;\n      }\n      return _ret;\n   }\n");
        }
        return stringBuffer.toString();
    }

    static String getNodeOptionalVisitorStr() {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("   public Object visit(NodeOptional n, Object argu) {\n");
        if (Globals.arguRet) {
            stringBuffer.append("      if ( n.present() )\n         return n.node.accept(this,argu);\n      else\n         return argu;\n   }\n");
        } else {
            stringBuffer.append("      if ( n.present() )\n         return n.node.accept(this,argu);\n      else\n         return null;\n   }\n");
        }
        return stringBuffer.toString();
    }

    static String getNodeSequenceVisitorStr() {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("   public Object visit(NodeSequence n, Object argu) {\n");
        if (Globals.arguRet) {
            stringBuffer.append("      Object _ret=argu;\n      int _count=0;\n      for ( Enumeration e = n.elements(); e.hasMoreElements(); ) {\n         _ret=((Node)e.nextElement()).accept(this,_ret);\n         _count++;\n      }\n      return _ret;\n   }\n");
        } else {
            stringBuffer.append("      Object _ret=null;\n      int _count=0;\n      for ( Enumeration e = n.elements(); e.hasMoreElements(); ) {\n         ((Node)e.nextElement()).accept(this,argu);\n         _count++;\n      }\n      return _ret;\n   }\n");
        }
        return stringBuffer.toString();
    }

    static String getNodeTokenVisitorStr() {
        if (Globals.arguRet) {
            return "   public Object visit(NodeToken n, Object argu) { return argu; }\n";
        }
        return "   public Object visit(NodeToken n, Object argu) { return null; }\n";
    }

    private void printAutoVisitorMethods(PrintWriter printWriter) {
        printWriter.println("   //");
        printWriter.println("   // Auto class visitors--probably don't need to be overridden.");
        printWriter.println("   //");
        printWriter.println(DepthFirstVisitorBuilder.getNodeListVisitorStr());
        printWriter.println(DepthFirstVisitorBuilder.getNodeListOptionalVisitorStr());
        printWriter.println(DepthFirstVisitorBuilder.getNodeOptionalVisitorStr());
        printWriter.println(DepthFirstVisitorBuilder.getNodeSequenceVisitorStr());
        printWriter.println(DepthFirstVisitorBuilder.getNodeTokenVisitorStr());
    }
}

