/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.jtb.misc.toolkit;

import EDU.purdue.jtb.misc.ClassInfo;
import EDU.purdue.jtb.misc.Errors;
import EDU.purdue.jtb.misc.FileExistsException;
import EDU.purdue.jtb.misc.Globals;
import EDU.purdue.jtb.misc.Spacing;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class OldDepthFirstVisitorBuilder {
    public static final String visitorName = "DepthFirstVisitor";
    public static final String outFilename = "DepthFirstVisitor.java";
    public static final int INDENT_AMT = 3;
    private Vector classList;
    private File visitorDir;

    public OldDepthFirstVisitorBuilder(Vector vector) {
        this.classList = vector;
        this.visitorDir = new File(Globals.visitorDir);
        if (!this.visitorDir.exists()) {
            this.visitorDir.mkdir();
        }
    }

    public void generateDepthFirstVisitor() throws FileExistsException {
        try {
            File file = new File(this.visitorDir, outFilename);
            if (Globals.noOverwrite && file.exists()) {
                throw new FileExistsException(outFilename);
            }
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file), false);
            Spacing spacing = new Spacing(3);
            printWriter.println(Globals.fileHeader(spacing));
            printWriter.println();
            printWriter.println(String.valueOf(spacing.spc) + "package " + Globals.visitorPackage + ";");
            if (!Globals.visitorPackage.equals(Globals.nodePackage)) {
                printWriter.println(String.valueOf(spacing.spc) + "import " + Globals.nodePackage + ".*;");
            }
            printWriter.println(String.valueOf(spacing.spc) + "import java.util.*;\n");
            printWriter.println(String.valueOf(spacing.spc) + "/**");
            printWriter.println(String.valueOf(spacing.spc) + " * Provides default methods which visit each " + "node in the tree in depth-first");
            printWriter.println(String.valueOf(spacing.spc) + " * order.  Your visitors may extend this class.");
            printWriter.println(String.valueOf(spacing.spc) + " */");
            printWriter.println(String.valueOf(spacing.spc) + "public class " + visitorName + " implements " + "Visitor" + " {");
            this.printAutoVisitorMethods(printWriter);
            spacing.updateSpc(1);
            printWriter.println(String.valueOf(spacing.spc) + "//");
            printWriter.println(String.valueOf(spacing.spc) + "// User-generated visitor methods below");
            printWriter.println(String.valueOf(spacing.spc) + "//");
            printWriter.println();
            Enumeration enumeration = this.classList.elements();
            while (enumeration.hasMoreElements()) {
                ClassInfo classInfo = (ClassInfo)enumeration.nextElement();
                String string = classInfo.getName();
                printWriter.println(String.valueOf(spacing.spc) + "/**");
                if (Globals.javaDocComments) {
                    printWriter.println(String.valueOf(spacing.spc) + " * <PRE>");
                }
                printWriter.println(classInfo.getEbnfProduction(spacing));
                if (Globals.javaDocComments) {
                    printWriter.println(String.valueOf(spacing.spc) + " * </PRE>");
                }
                printWriter.println(String.valueOf(spacing.spc) + " */");
                printWriter.print(String.valueOf(spacing.spc) + "public void visit");
                printWriter.println("(" + string + " n) {");
                spacing.updateSpc(1);
                Enumeration enumeration2 = classInfo.getNameList().elements();
                while (enumeration2.hasMoreElements()) {
                    printWriter.println(String.valueOf(spacing.spc) + "n." + (String)enumeration2.nextElement() + ".accept(this);");
                }
                spacing.updateSpc(-1);
                printWriter.println(String.valueOf(spacing.spc) + "}\n");
            }
            spacing.updateSpc(-1);
            printWriter.println(String.valueOf(spacing.spc) + "}");
            printWriter.flush();
            printWriter.close();
        }
        catch (IOException iOException) {
            Errors.hardErr("Could not generate DepthFirstVisitor.java");
        }
    }

    static String getNodeListOptionalVisitorStr() {
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("   public void visit(NodeListOptional n) {\n");
        stringBuffer.append("      if ( n.present() )\n         for ( Enumeration e = n.elements(); e.hasMoreElements(); )\n            ((Node)e.nextElement()).accept(this);\n   }\n");
        return stringBuffer.toString();
    }

    static String getNodeListVisitorStr() {
        StringBuffer stringBuffer = new StringBuffer(240);
        stringBuffer.append("   public void visit(NodeList n) {\n");
        stringBuffer.append("      for ( Enumeration e = n.elements(); e.hasMoreElements(); )\n         ((Node)e.nextElement()).accept(this);\n   }\n");
        return stringBuffer.toString();
    }

    static String getNodeOptionalVisitorStr() {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("   public void visit(NodeOptional n) {\n");
        stringBuffer.append("      if ( n.present() )\n         n.node.accept(this);\n   }\n");
        return stringBuffer.toString();
    }

    static String getNodeSequenceVisitorStr() {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("   public void visit(NodeSequence n) {\n");
        stringBuffer.append("      for ( Enumeration e = n.elements(); e.hasMoreElements(); )\n         ((Node)e.nextElement()).accept(this);\n   }\n");
        return stringBuffer.toString();
    }

    static String getNodeTokenVisitorStr() {
        return "   public void visit(NodeToken n) { }\n";
    }

    private void printAutoVisitorMethods(PrintWriter printWriter) {
        printWriter.println("   //");
        printWriter.println("   // Auto class visitors--probably don't need to be overridden.");
        printWriter.println("   //");
        printWriter.println(OldDepthFirstVisitorBuilder.getNodeListVisitorStr());
        printWriter.println(OldDepthFirstVisitorBuilder.getNodeListOptionalVisitorStr());
        printWriter.println(OldDepthFirstVisitorBuilder.getNodeOptionalVisitorStr());
        printWriter.println(OldDepthFirstVisitorBuilder.getNodeSequenceVisitorStr());
        printWriter.println(OldDepthFirstVisitorBuilder.getNodeTokenVisitorStr());
    }
}

