/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.jtb.misc.toolkit;

import EDU.purdue.jtb.misc.ClassInfo;
import EDU.purdue.jtb.misc.Errors;
import EDU.purdue.jtb.misc.FileExistsException;
import EDU.purdue.jtb.misc.Globals;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class SchemeRecordBuilder {
    public static final String outFilename = "records.scm";
    public static final int INDENT_AMT = 3;
    public static final int MAX_PER_LINE = 4;
    private Vector classList;
    private PrintWriter out;

    public SchemeRecordBuilder(Vector vector) {
        this.classList = vector;
    }

    public void generateSchemeRecords() throws FileExistsException {
        try {
            File file = new File(outFilename);
            if (Globals.noOverwrite && file.exists()) {
                throw new FileExistsException(outFilename);
            }
            this.out = new PrintWriter(new FileOutputStream(file), false);
            Enumeration enumeration = this.classList.elements();
            while (enumeration.hasMoreElements()) {
                ClassInfo classInfo = (ClassInfo)enumeration.nextElement();
                String string = classInfo.getName();
                Vector vector = classInfo.getTypeList();
                int n = classInfo.getNameList().size();
                int n2 = 1;
                if (classInfo.getNameList().size() <= 1 && vector.elementAt(0).equals("NodeChoice")) continue;
                Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
                this.out.print("(define-record " + string + " (");
                int n3 = 0;
                while (n3 < n) {
                    if (vector.elementAt(n3).equals("NodeChoice")) {
                        Errors.softErr("In production " + string + ": choices may " + "only occur at the top level.");
                    } else if (vector.elementAt(n3).equals("NodeSequence")) {
                        Errors.softErr("In production " + string + ": only single " + "nonterminals may appear within Lists, ListOptionals," + " Optionals, and Choices.");
                    } else {
                        int n4;
                        String string2 = (String)vector.elementAt(n3);
                        Integer n5 = (Integer)hashtable.get(string2);
                        if (vector.elementAt(n3).equals("NodeList") || vector.elementAt(n3).equals("NodeListOptional")) {
                            this.out.print("List");
                        } else if (vector.elementAt(n3).equals("NodeOptional")) {
                            this.out.print("Optional");
                        } else if (vector.elementAt(n3).equals("NodeToken")) {
                            this.out.print("Token");
                        } else {
                            this.out.print(string2);
                        }
                        if (n5 == null) {
                            n4 = n3 + 1;
                            while (n4 < n) {
                                if (vector.elementAt(n4).equals(string2)) {
                                    this.out.print("1");
                                    break;
                                }
                                ++n4;
                            }
                            hashtable.put(string2, new Integer(1));
                        } else {
                            n4 = n5 + 1;
                            this.out.print(n4);
                            hashtable.put(string2, new Integer(n4));
                        }
                    }
                    ++n2;
                    if (n3 < n - 1) {
                        if (n2 >= 4) {
                            this.out.println();
                            this.out.print("   ");
                            n2 = 0;
                        } else {
                            this.out.print(" ");
                        }
                    }
                    ++n3;
                }
                this.out.println("))");
            }
            this.out.flush();
            this.out.close();
        }
        catch (IOException iOException) {
            Errors.hardErr("Could not generate records.scm");
        }
    }
}

