/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.jtb.misc.toolkit;

import EDU.purdue.jtb.misc.Errors;
import EDU.purdue.jtb.syntaxtree.BNFProduction;
import EDU.purdue.jtb.syntaxtree.Expansion;
import EDU.purdue.jtb.syntaxtree.ExpansionChoices;
import EDU.purdue.jtb.syntaxtree.ExpansionUnit;
import EDU.purdue.jtb.syntaxtree.JavaCCInput;
import EDU.purdue.jtb.syntaxtree.JavaCodeProduction;
import EDU.purdue.jtb.syntaxtree.LocalLookahead;
import EDU.purdue.jtb.syntaxtree.Production;
import EDU.purdue.jtb.syntaxtree.RegularExprProduction;
import EDU.purdue.jtb.syntaxtree.TokenManagerDecls;
import EDU.purdue.jtb.visitor.DepthFirstVisitor;
import EDU.purdue.jtb.visitor.ExpansionUnitTypeCounter;

public class SchemeSemanticChecker
extends DepthFirstVisitor {
    private boolean errorReported = false;
    private boolean topLevel = true;
    private String curProd;

    public void visit(BNFProduction bNFProduction) {
        this.curProd = bNFProduction.f1.tokenImage;
        bNFProduction.f6.accept(this);
        this.errorReported = false;
    }

    public void visit(Expansion expansion) {
        if (!this.errorReported && !this.topLevel && expansion.f0.size() > 1) {
            ExpansionUnitTypeCounter expansionUnitTypeCounter = new ExpansionUnitTypeCounter();
            expansion.accept(expansionUnitTypeCounter);
            if (expansionUnitTypeCounter.getNumNormals() > 1) {
                Errors.softErr("In " + this.curProd + "()--only single " + "nonterminals may appear below the top level.");
                this.errorReported = true;
            }
        } else {
            expansion.f0.accept(this);
        }
    }

    public void visit(ExpansionChoices expansionChoices) {
        if (expansionChoices.f1.present()) {
            if (!this.errorReported && !this.topLevel) {
                Errors.softErr("In " + this.curProd + "()--choices may occur " + "only at the top level.");
                this.errorReported = true;
            } else {
                this.topLevel = false;
                expansionChoices.f0.accept(this);
                expansionChoices.f1.accept(this);
                this.topLevel = true;
            }
        } else {
            expansionChoices.f0.accept(this);
            expansionChoices.f1.accept(this);
        }
    }

    public void visit(ExpansionUnit expansionUnit) {
        switch (expansionUnit.f0.which) {
            case 0: {
                return;
            }
            case 1: {
                return;
            }
            case 2: 
            case 3: {
                if (this.topLevel) {
                    this.topLevel = false;
                    expansionUnit.f0.accept(this);
                    this.topLevel = true;
                } else {
                    expansionUnit.f0.accept(this);
                }
            }
            case 4: {
                return;
            }
        }
        Errors.hardErr("n.f0.which = " + String.valueOf(expansionUnit.f0.which));
    }

    public void visit(JavaCCInput javaCCInput) {
        javaCCInput.f10.accept(this);
    }

    public void visit(JavaCodeProduction javaCodeProduction) {
    }

    public void visit(LocalLookahead localLookahead) {
    }

    public void visit(Production production) {
        production.f0.accept(this);
    }

    public void visit(RegularExprProduction regularExprProduction) {
    }

    public void visit(TokenManagerDecls tokenManagerDecls) {
    }
}

