/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.jtb.misc.toolkit;

import EDU.purdue.jtb.misc.Errors;
import EDU.purdue.jtb.misc.FileExistsException;
import EDU.purdue.jtb.misc.Globals;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class TreeDumperBuilder {
    public static final String visitorName = "TreeDumper";
    public static final String outFilename = "TreeDumper.java";
    private File visitorDir = new File(Globals.visitorDir);

    public TreeDumperBuilder() {
        if (!this.visitorDir.exists()) {
            this.visitorDir.mkdir();
        }
    }

    public void generateTreeDumper() throws FileExistsException {
        try {
            File file = new File(this.visitorDir, outFilename);
            if (Globals.noOverwrite && file.exists()) {
                throw new FileExistsException(outFilename);
            }
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file), false);
            printWriter.println(Globals.fileHeader());
            printWriter.print("package " + Globals.visitorPackage + ";\n\n" + "import " + Globals.nodePackage + ".*;\n" + "import java.util.*;\n" + "import java.io.*;\n\n" + "/**\n" + " * Dumps the syntax tree to a Writer using the location information in\n" + " * each NodeToken.\n" + " */\n" + "public class TreeDumper extends " + "DepthFirstVisitor" + " {\n" + "   protected PrintWriter out;\n" + "   private int curLine = 1;\n" + "   private int curColumn = 1;\n" + "   private boolean startAtNextToken = false;\n" + "   private boolean printSpecials = true;\n\n" + "   /**\n" + "    * The default constructor uses System.out as its output location.\n" + "    * You may specify your own Writer or OutputStream using one of the\n" + "    * other constructors.\n" + "    */\n" + "   public TreeDumper()       { out = new PrintWriter(System.out, true); }\n" + "   public TreeDumper(Writer o)        { out = new PrintWriter(o, true); }\n" + "   public TreeDumper(OutputStream o)  { out = new PrintWriter(o, true); }\n\n" + "   /**\n" + "    * Flushes the OutputStream or Writer that this TreeDumper is using.\n" + "    */\n" + "   public void flushWriter()        { out.flush(); }\n\n" + "   /**\n" + "    * Allows you to specify whether or not to print special tokens.\n" + "    */\n" + "   public void printSpecials(boolean b)   { printSpecials = b; }\n\n" + "   /**\n" + "    * Starts the tree dumper on the line containing the next token\n" + "    * visited.  For example, if the next token begins on line 50 and the\n" + "    * dumper is currently on line 1 of the file, it will set its current\n" + "    * line to 50 and continue printing from there, as opposed to\n" + "    * printing 49 blank lines and then printing the token.\n" + "    */\n" + "   public void startAtNextToken()   { startAtNextToken = true; }\n\n" + "   /**\n" + "    * Resets the position of the output \"cursor\" to the first line and\n" + "    * column.  When using a dumper on a syntax tree more than once, you\n" + "    * either need to call this method or startAtNextToken() between each\n" + "    * dump.\n" + "    */\n" + "   public void resetPosition()      { curLine = curColumn = 1; }\n\n" + "   /**\n" + "    * Dumps the current NodeToken to the output stream being used.\n" + "    *\n" + "    * @throws  IllegalStateException   if the token position is invalid\n" + "    *   relative to the current position, i.e. its location places it\n" + "    *   before the previous token.\n" + "    */\n");
            printWriter.print("   public void visit(NodeToken n) {\n");
            printWriter.print("      if ( n.beginLine == -1 || n.beginColumn == -1 ) {\n         printToken(n.tokenImage);\n         return;\n      }\n\n      //\n      // Handle special tokens\n      //\n      if ( printSpecials && n.numSpecials() > 0 )\n         for ( Enumeration e = n.specialTokens.elements(); e.hasMoreElements(); )\n            visit((NodeToken)e.nextElement());\n\n      //\n      // Handle startAtNextToken option\n      //\n      if ( startAtNextToken ) {\n         curLine = n.beginLine;\n         curColumn = 1;\n         startAtNextToken = false;\n\n         if ( n.beginColumn < curColumn )\n            out.println();\n      }\n\n      //\n      // Check for invalid token position relative to current position.\n      //\n      if ( n.beginLine < curLine )\n         throw new IllegalStateException(\"at token \\\"\" + n.tokenImage +\n            \"\\\", n.beginLine = \" + Integer.toString(n.beginLine) +\n            \", curLine = \" + Integer.toString(curLine));\n      else if ( n.beginLine == curLine && n.beginColumn < curColumn )\n         throw new IllegalStateException(\"at token \\\"\" + n.tokenImage +\n            \"\\\", n.beginColumn = \" +\n            Integer.toString(n.beginColumn) + \", curColumn = \" +\n            Integer.toString(curColumn));\n\n      //\n      // Move output \"cursor\" to proper location, then print the token\n      //\n      if ( curLine < n.beginLine ) {\n         curColumn = 1;\n         for ( ; curLine < n.beginLine; ++curLine )\n            out.println();\n      }\n\n      for ( ; curColumn < n.beginColumn; ++curColumn )\n         out.print(\" \");\n\n      printToken(n.tokenImage);\n   }\n\n   private void printToken(String s) {\n      for ( int i = 0; i < s.length(); ++i ) { \n         if ( s.charAt(i) == '\\n' ) {\n            ++curLine;\n            curColumn = 1;\n         }\n         else\n            curColumn++;\n\n         out.print(s.charAt(i));\n      }\n\n      out.flush();\n   }\n}\n");
            printWriter.flush();
        }
        catch (IOException iOException) {
            Errors.hardErr("Could not generate TreeDumper.java");
        }
    }
}

