/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.jtb.misc.toolkit;

import EDU.purdue.jtb.misc.ClassInfo;
import EDU.purdue.jtb.misc.Errors;
import EDU.purdue.jtb.misc.FileExistsException;
import EDU.purdue.jtb.misc.Globals;
import EDU.purdue.jtb.misc.Spacing;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class TreeFormatterBuilder {
    public static final String visitorName = "TreeFormatter";
    public static final String outFilename = "TreeFormatter.java";
    private File visitorDir;
    private Vector classList;

    public TreeFormatterBuilder(Vector vector) {
        this.classList = vector;
        this.visitorDir = new File(Globals.visitorDir);
        if (!this.visitorDir.exists()) {
            this.visitorDir.mkdir();
        }
    }

    public void generateTreeFormatter() throws FileExistsException {
        try {
            File file = new File(this.visitorDir, outFilename);
            if (file.exists()) {
                throw new FileExistsException(outFilename);
            }
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file), false);
            printWriter.println(Globals.fileHeader());
            printWriter.print("package " + Globals.visitorPackage + ";\n\n" + "import " + Globals.nodePackage + ".*;\n" + "import java.util.*;\n\n" + "/**\n" + " * A skeleton output formatter for your language grammar.  Using the\n" + " * add() method along with force(), indent(), and outdent(), you can\n" + " * easily specify how this visitor will format the given syntax tree.\n" + " * See the JTB documentation for more details.\n" + " *\n" + " * Pass your syntax tree to this visitor, and then to the TreeDumper\n" + " * visitor in order to \"pretty print\" your tree.\n" + " */\n" + "public class TreeFormatter extends " + "DepthFirstVisitor" + " {\n" + "   private Vector cmdQueue = new Vector();\n" + "   private boolean lineWrap;\n" + "   private int wrapWidth;\n" + "   private int indentAmt;\n" + "   private int curLine = 1;\n" + "   private int curColumn = 1;\n" + "   private int curIndent = 0;\n\n" + "   /**\n" + "    * The default constructor assumes an indentation amount of 3 spaces\n" + "    * and no line-wrap.  You may alternately use the other constructor to\n" + "    * specify your own indentation amount and line width.\n" + "    */\n" + "   public TreeFormatter() { this(3, 0); }\n\n" + "   /**\n" + "    * This constructor accepts an indent amount and a line width which is\n" + "    * used to wrap long lines.  If a token's beginColumn value is greater\n" + "    * than the specified wrapWidth, it will be moved to the next line and\n" + "    * indented one extra level.  To turn off line-wrapping, specify a\n" + "    * wrapWidth of 0.\n" + "    *\n" + "    * @param   indentAmt   Amount of spaces per indentation level.\n" + "    * @param   wrapWidth   Wrap lines longer than wrapWidth.  0 for no wrap.\n" + "    */\n" + "   public TreeFormatter(int indentAmt, int wrapWidth) {\n" + "      this.indentAmt = indentAmt;\n" + "      this.wrapWidth = wrapWidth;\n\n" + "      if ( wrapWidth > 0 )\n" + "         lineWrap = true;\n" + "      else\n" + "         lineWrap = false;\n" + "   }\n\n" + "   /**\n" + "    * Accepts a NodeListInterface object and performs an optional format\n" + "    * command between each node in the list (but not after the last node).\n" + "    */\n" + "   protected void processList(NodeListInterface n) {\n" + "      processList(n, null);\n" + "   }\n\n" + "   protected void processList(NodeListInterface n, FormatCommand cmd) {\n" + "      for ( Enumeration e = n.elements(); e.hasMoreElements(); ) {\n" + "         ((Node)e.nextElement()).accept(this);\n" + "         if ( cmd != null && e.hasMoreElements() )\n" + "            cmdQueue.addElement(cmd);\n" + "      }\n" + "   }\n\n" + "   /**\n" + "    * A Force command inserts a line break and indents the next line to\n" + "    * the current indentation level.  Use \"add(force());\".\n" + "    */\n" + "   protected FormatCommand force() { return force(1); }\n" + "   protected FormatCommand force(int i) {\n" + "      return new FormatCommand(FormatCommand.FORCE, i);\n" + "   }\n\n" + "   /**\n" + "    * An Indent command increases the indentation level by one (or a\n" + "    * user-specified amount).  Use \"add(indent());\".\n" + "    */\n" + "   protected FormatCommand indent() { return indent(1); }\n" + "   protected FormatCommand indent(int i) {\n" + "      return new FormatCommand(FormatCommand.INDENT, i);\n" + "   }\n\n" + "   /**\n" + "    * An Outdent command is the reverse of the Indent command: it reduces\n" + "    * the indentation level.  Use \"add(outdent());\".\n" + "    */\n" + "   protected FormatCommand outdent() { return outdent(1); }\n" + "   protected FormatCommand outdent(int i) {\n" + "      return new FormatCommand(FormatCommand.OUTDENT, i);\n" + "   }\n\n" + "   /**\n" + "    * A Space command simply adds one or a user-specified number of\n" + "    * spaces between tokens.  Use \"add(space());\".\n" + "    */\n" + "   protected FormatCommand space() { return space(1); }\n" + "   protected FormatCommand space(int i) {\n" + "      return new FormatCommand(FormatCommand.SPACE, i);\n" + "   }\n\n" + "   /**\n" + "    * Use this method to add FormatCommands to the command queue to be\n" + "    * executed when the next token in the tree is visited.\n" + "    */\n" + "   protected void add(FormatCommand cmd) {\n" + "      cmdQueue.addElement(cmd);\n" + "   }\n\n" + "   /**\n" + "    * Executes the commands waiting in the command queue, then inserts the\n" + "    * proper location information into the current NodeToken.\n" + "    *\n" + "    * If there are any special tokens preceding this token, they will be\n" + "    * given the current location information.  The token will follow on\n" + "    * the next line, at the proper indentation level.  If this is not the\n" + "    * behavior you want from special tokens, feel free to modify this\n" + "    * method.\n" + "    */\n" + "   public void visit(NodeToken n) {\n" + "      for ( Enumeration e = cmdQueue.elements(); e.hasMoreElements(); ) {\n" + "         FormatCommand cmd = (FormatCommand)e.nextElement();\n" + "         switch ( cmd.getCommand() ) {\n" + "         case FormatCommand.FORCE :\n" + "            curLine += cmd.getNumCommands();\n" + "            curColumn = curIndent + 1;\n" + "            break;\n" + "         case FormatCommand.INDENT :\n" + "            curIndent += indentAmt * cmd.getNumCommands();\n" + "            break;\n" + "         case FormatCommand.OUTDENT :\n" + "            if ( curIndent >= indentAmt )\n" + "               curIndent -= indentAmt * cmd.getNumCommands();\n" + "            break;\n" + "         case FormatCommand.SPACE :\n" + "            curColumn += cmd.getNumCommands();\n" + "            break;\n" + "         default :\n" + "            throw new TreeFormatterException(\n" + "               \"Invalid value in command queue.\");\n" + "         }\n" + "      }\n\n" + "      cmdQueue.removeAllElements();\n\n" + "      //\n" + "      // Handle all special tokens preceding this NodeToken\n" + "      //\n" + "      if ( n.numSpecials() > 0 )\n" + "         for ( Enumeration e = n.specialTokens.elements();\n" + "               e.hasMoreElements(); ) {\n" + "            NodeToken special = (NodeToken)e.nextElement();\n\n" + "            //\n" + "            // -Place the token.\n" + "            // -Move cursor to next line after the special token.\n" + "            // -Don't update curColumn--want to keep current indent level.\n" + "            //\n" + "            placeToken(special, curLine, curColumn);\n" + "            curLine = special.endLine + 1;\n" + "         }\n\n" + "      placeToken(n, curLine, curColumn);\n" + "      curLine = n.endLine;\n" + "      curColumn = n.endColumn;\n" + "   }\n\n" + "   /**\n" + "    * Inserts token location (beginLine, beginColumn, endLine, endColumn)\n" + "    * information into the NodeToken.  Takes into account line-wrap.\n" + "    * Does not update curLine and curColumn.\n" + "    */\n" + "   private void placeToken(NodeToken n, int line, int column) {\n" + "      int length = n.tokenImage.length();\n\n" + "      //\n" + "      // Find beginning of token.  Only line-wrap for single-line tokens\n" + "      //\n" + "      if ( !lineWrap || n.tokenImage.indexOf('\\n') != -1 ||\n" + "           column + length <= wrapWidth )\n" + "         n.beginColumn = column;\n" + "      else {\n" + "         ++line;\n" + "         column = curIndent + indentAmt + 1;\n" + "         n.beginColumn = column;\n" + "      }\n\n" + "      n.beginLine = line;\n\n" + "      //\n" + "      // Find end of token; don't count \\n if it's the last character\n" + "      //\n" + "      for ( int i = 0; i < length; ++i ) {\n" + "         if ( n.tokenImage.charAt(i) == '\\n' && i < length - 1 ) {\n" + "            ++line;\n" + "            column = 1;\n" + "         }\n" + "         else\n" + "            ++column;\n" + "      }\n\n" + "      n.endLine = line;\n" + "      n.endColumn = column;\n" + "   }\n\n" + "   //\n" + "   // User-generated visitor methods below\n" + "   //\n\n");
            printWriter.flush();
            Spacing spacing = new Spacing(3);
            spacing.updateSpc(1);
            Enumeration enumeration = this.classList.elements();
            while (enumeration.hasMoreElements()) {
                ClassInfo classInfo = (ClassInfo)enumeration.nextElement();
                String string = classInfo.getName();
                printWriter.println(String.valueOf(spacing.spc) + "/**");
                if (Globals.javaDocComments) {
                    printWriter.println(String.valueOf(spacing.spc) + " * <PRE>");
                }
                printWriter.println(classInfo.getEbnfProduction(spacing));
                if (Globals.javaDocComments) {
                    printWriter.println(String.valueOf(spacing.spc) + " * </PRE>");
                }
                printWriter.println(String.valueOf(spacing.spc) + " */");
                printWriter.print(String.valueOf(spacing.spc) + "public void visit");
                printWriter.println("(" + string + " n) {");
                spacing.updateSpc(1);
                Enumeration enumeration2 = classInfo.getNameList().elements();
                Enumeration enumeration3 = classInfo.getTypeList().elements();
                while (enumeration2.hasMoreElements() && enumeration3.hasMoreElements()) {
                    String string2 = (String)enumeration2.nextElement();
                    String string3 = (String)enumeration3.nextElement();
                    if (string3.equals("NodeList")) {
                        printWriter.println(String.valueOf(spacing.spc) + "processList(n." + string2 + ");");
                        continue;
                    }
                    if (string3.equals("NodeListOptional")) {
                        printWriter.println(String.valueOf(spacing.spc) + "if ( n." + string2 + ".present() ) {");
                        spacing.updateSpc(1);
                        printWriter.println(String.valueOf(spacing.spc) + "processList(n." + string2 + ");");
                        spacing.updateSpc(-1);
                        printWriter.println(String.valueOf(spacing.spc) + "}");
                        continue;
                    }
                    if (string3.equals("NodeOptional")) {
                        printWriter.println(String.valueOf(spacing.spc) + "if ( n." + string2 + ".present() ) {");
                        spacing.updateSpc(1);
                        printWriter.println(String.valueOf(spacing.spc) + "n." + string2 + ".accept(this);");
                        spacing.updateSpc(-1);
                        printWriter.println(String.valueOf(spacing.spc) + "}");
                        continue;
                    }
                    printWriter.println(String.valueOf(spacing.spc) + "n." + string2 + ".accept(this);");
                }
                spacing.updateSpc(-1);
                printWriter.println(String.valueOf(spacing.spc) + "}\n");
            }
            spacing.updateSpc(-1);
            printWriter.println(String.valueOf(spacing.spc) + "}\n");
            printWriter.print("class FormatCommand {\n   public static final int FORCE = 0;\n   public static final int INDENT = 1;\n   public static final int OUTDENT = 2;\n   public static final int SPACE = 3;\n\n   private int command;\n   private int numCommands;\n\n   FormatCommand(int command, int numCommands) {\n      this.command = command;\n      this.numCommands = numCommands;\n   }\n\n   public int getCommand()             { return command; }\n   public int getNumCommands()         { return numCommands; }\n   public void setCommand(int i)       { command = i; }\n   public void setNumCommands(int i)   { numCommands = i; }\n}\n\nclass TreeFormatterException extends RuntimeException {\n   TreeFormatterException()         { super(); }\n   TreeFormatterException(String s) { super(s); }\n}\n");
            printWriter.flush();
        }
        catch (IOException iOException) {
            Errors.hardErr("Could not generate TreeFormatter.java");
        }
    }
}

