/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.jtb.misc;

import EDU.purdue.jtb.misc.ClassInfo;
import EDU.purdue.jtb.misc.Errors;
import EDU.purdue.jtb.misc.FileExistsException;
import EDU.purdue.jtb.misc.Globals;
import EDU.purdue.jtb.misc.OldAutoClasses;
import EDU.purdue.jtb.misc.Spacing;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;

public class OldFileGenerator {
    public static final int INDENT_AMT = 3;
    private Vector classList;
    private File nodeDir;
    private File visitorDir;

    public OldFileGenerator(Vector vector) {
        this.classList = vector;
        this.nodeDir = new File(Globals.nodeDir);
        this.visitorDir = new File(Globals.visitorDir);
        if (!this.nodeDir.exists()) {
            this.nodeDir.mkdir();
        } else if (!this.nodeDir.isDirectory()) {
            Errors.softErr("\"" + Globals.nodeDir + "\" exists but is not a " + "directory.");
        }
        if (!this.visitorDir.exists()) {
            this.visitorDir.mkdir();
        } else if (!this.visitorDir.isDirectory()) {
            Errors.softErr("\"" + Globals.visitorDir + "\" exists but is not a " + "directory.");
        }
    }

    public void generateVisitorFile() throws FileExistsException {
        try {
            File file = new File(this.visitorDir, "Visitor.java");
            if (Globals.noOverwrite && file.exists()) {
                throw new FileExistsException("Visitor.java");
            }
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(file), false);
            Spacing spacing = new Spacing(3);
            printWriter.println(Globals.fileHeader(spacing));
            printWriter.println();
            printWriter.println(String.valueOf(spacing.spc) + "package " + Globals.visitorPackage + ";");
            if (!Globals.visitorPackage.equals(Globals.nodePackage)) {
                printWriter.println(String.valueOf(spacing.spc) + "import " + Globals.nodePackage + ".*;");
            }
            printWriter.println(String.valueOf(spacing.spc) + "import java.util.*;\n");
            printWriter.println(String.valueOf(spacing.spc) + "/**");
            printWriter.println(String.valueOf(spacing.spc) + " * All void visitors must implement this interface.");
            printWriter.println(String.valueOf(spacing.spc) + " */");
            printWriter.println(String.valueOf(spacing.spc) + "public interface " + "Visitor" + " {");
            this.printAutoVisitorMethods(printWriter);
            spacing.updateSpc(1);
            printWriter.println(String.valueOf(spacing.spc) + "//");
            printWriter.println(String.valueOf(spacing.spc) + "// User-generated visitor methods below");
            printWriter.println(String.valueOf(spacing.spc) + "//");
            printWriter.println();
            Enumeration enumeration = this.classList.elements();
            while (enumeration.hasMoreElements()) {
                ClassInfo classInfo = (ClassInfo)enumeration.nextElement();
                String string = classInfo.getName();
                printWriter.println(String.valueOf(spacing.spc) + "/**");
                if (Globals.javaDocComments) {
                    printWriter.println(String.valueOf(spacing.spc) + " * <PRE>");
                }
                printWriter.println(classInfo.getEbnfProduction(spacing));
                if (Globals.javaDocComments) {
                    printWriter.println(String.valueOf(spacing.spc) + " * </PRE>");
                }
                printWriter.println(String.valueOf(spacing.spc) + " */");
                printWriter.print(String.valueOf(spacing.spc) + "public void visit");
                printWriter.println("(" + string + " n);\n");
            }
            spacing.updateSpc(-1);
            printWriter.println(String.valueOf(spacing.spc) + "}\n");
            printWriter.flush();
            printWriter.close();
        }
        catch (IOException iOException) {
            Errors.hardErr(iOException);
        }
    }

    private void printAutoVisitorMethods(PrintWriter printWriter) {
        printWriter.println("   //");
        printWriter.println("   // void Auto class visitors");
        printWriter.println("   //");
        printWriter.print(OldAutoClasses.getNodeListVisitorStr());
        printWriter.print(OldAutoClasses.getNodeListOptionalVisitorStr());
        printWriter.print(OldAutoClasses.getNodeOptionalVisitorStr());
        printWriter.print(OldAutoClasses.getNodeSequenceVisitorStr());
        printWriter.print(OldAutoClasses.getNodeTokenVisitorStr());
        printWriter.println();
    }
}

