/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.jtb.visitor;

import EDU.purdue.jtb.misc.ClassInfo;
import EDU.purdue.jtb.misc.Errors;
import EDU.purdue.jtb.misc.FieldNameGenerator;
import EDU.purdue.jtb.syntaxtree.BNFProduction;
import EDU.purdue.jtb.syntaxtree.Expansion;
import EDU.purdue.jtb.syntaxtree.ExpansionChoices;
import EDU.purdue.jtb.syntaxtree.ExpansionUnit;
import EDU.purdue.jtb.syntaxtree.ExpansionUnitTerm;
import EDU.purdue.jtb.syntaxtree.JavaCCInput;
import EDU.purdue.jtb.syntaxtree.JavaCodeProduction;
import EDU.purdue.jtb.syntaxtree.LocalLookahead;
import EDU.purdue.jtb.syntaxtree.NodeChoice;
import EDU.purdue.jtb.syntaxtree.NodeOptional;
import EDU.purdue.jtb.syntaxtree.NodeSequence;
import EDU.purdue.jtb.syntaxtree.NodeToken;
import EDU.purdue.jtb.syntaxtree.RegularExprProduction;
import EDU.purdue.jtb.syntaxtree.RegularExpression;
import EDU.purdue.jtb.syntaxtree.TokenManagerDecls;
import EDU.purdue.jtb.visitor.DepthFirstVisitor;
import EDU.purdue.jtb.visitor.TokenTableBuilder;
import java.util.Hashtable;
import java.util.Vector;

public class ClassGenerator
extends DepthFirstVisitor {
    private boolean printToken = false;
    private Hashtable tokenTable;
    private ClassInfo curClass;
    private Vector classList = new Vector();
    private FieldNameGenerator nameGen = new FieldNameGenerator();

    public Vector getClassList() {
        return this.classList;
    }

    private String getNameForMod(String string) {
        if (string.equals("+")) {
            return "NodeList";
        }
        if (string.equals("*")) {
            return "NodeListOptional";
        }
        if (string.equals("?")) {
            return "NodeOptional";
        }
        Errors.hardErr("Illegal EBNF modifier in ExpansionUnit: mod = " + string);
        return "";
    }

    public void visit(BNFProduction bNFProduction) {
        this.nameGen.resetFieldNum();
        this.printToken = true;
        this.curClass = new ClassInfo(bNFProduction.f6, bNFProduction.f1.toString());
        this.classList.addElement(this.curClass);
        bNFProduction.f6.accept(this);
        this.printToken = false;
    }

    public void visit(Expansion expansion) {
        expansion.f0.accept(this);
    }

    public void visit(ExpansionChoices expansionChoices) {
        if (!expansionChoices.f1.present()) {
            expansionChoices.f0.accept(this);
        } else {
            this.curClass.addField("NodeChoice", this.nameGen.curFieldName("NodeChoice"));
        }
    }

    public void visit(ExpansionUnit expansionUnit) {
        switch (expansionUnit.f0.which) {
            case 0: {
                return;
            }
            case 1: {
                return;
            }
            case 2: {
                NodeSequence nodeSequence = (NodeSequence)expansionUnit.f0.choice;
                NodeOptional nodeOptional = (NodeOptional)nodeSequence.elementAt(3);
                if (nodeOptional.present()) {
                    NodeChoice nodeChoice = (NodeChoice)nodeOptional.node;
                    String string = ((NodeToken)nodeChoice.choice).tokenImage;
                    String string2 = this.getNameForMod(string);
                    this.curClass.addField(string2, this.nameGen.curFieldName(string2));
                    break;
                }
                ExpansionChoices expansionChoices = (ExpansionChoices)nodeSequence.elementAt(1);
                if (expansionChoices.f1.present()) {
                    this.curClass.addField("NodeChoice", this.nameGen.curFieldName("NodeChoice"));
                    break;
                }
                this.curClass.addField("NodeSequence", this.nameGen.curFieldName("NodeSequence"));
                break;
            }
            case 3: {
                this.curClass.addField("NodeOptional", this.nameGen.curFieldName("NodeOptional"));
                break;
            }
            case 4: {
                expansionUnit.f0.accept(this);
                break;
            }
            default: {
                Errors.hardErr("n.f0.which = " + String.valueOf(expansionUnit.f0.which));
            }
        }
    }

    public void visit(ExpansionUnitTerm expansionUnitTerm) {
        switch (expansionUnitTerm.f0.which) {
            case 0: {
                expansionUnitTerm.f0.accept(this);
                break;
            }
            case 1: {
                NodeSequence nodeSequence = (NodeSequence)expansionUnitTerm.f0.choice;
                String string = ((NodeToken)nodeSequence.elementAt((int)0)).tokenImage;
                this.curClass.addField(string, this.nameGen.curFieldName(string));
                break;
            }
            default: {
                Errors.hardErr("n.f0.which = " + String.valueOf(expansionUnitTerm.f0.which));
            }
        }
    }

    public void visit(JavaCCInput javaCCInput) {
        TokenTableBuilder tokenTableBuilder = new TokenTableBuilder();
        javaCCInput.accept(tokenTableBuilder);
        this.tokenTable = tokenTableBuilder.getTokenTable();
        javaCCInput.f10.accept(this);
    }

    public void visit(JavaCodeProduction javaCodeProduction) {
    }

    public void visit(LocalLookahead localLookahead) {
    }

    public void visit(RegularExprProduction regularExprProduction) {
    }

    public void visit(RegularExpression regularExpression) {
        String string = "";
        String string2 = null;
        boolean bl = false;
        if (!this.printToken) {
            return;
        }
        switch (regularExpression.f0.which) {
            case 0: {
                string = ((NodeToken)regularExpression.f0.choice).tokenImage;
                break;
            }
            case 1: {
                string = "";
                break;
            }
            case 2: {
                NodeSequence nodeSequence = (NodeSequence)regularExpression.f0.choice;
                NodeToken nodeToken = (NodeToken)nodeSequence.elementAt(1);
                string = (String)this.tokenTable.get(nodeToken.tokenImage);
                if (string != null) break;
                Errors.softErr("Undefined token \"" + nodeToken + "\".", nodeToken.beginLine);
                string = "";
                break;
            }
            case 3: {
                string = "";
                bl = true;
                break;
            }
            default: {
                Errors.hardErr("Unreachable code executed!");
            }
        }
        if (bl) {
            string2 = "new NodeToken(\"\")";
        } else if (string != "") {
            string2 = "new NodeToken(" + string + ")";
        }
        this.curClass.addField("NodeToken", this.nameGen.curFieldName("NodeToken"), string2);
    }

    public void visit(TokenManagerDecls tokenManagerDecls) {
    }
}

