/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.jtb.visitor;

import EDU.purdue.jtb.misc.Errors;
import EDU.purdue.jtb.misc.JavaStringMaker;
import EDU.purdue.jtb.misc.Spacing;
import EDU.purdue.jtb.syntaxtree.BNFProduction;
import EDU.purdue.jtb.syntaxtree.CharacterDescriptor;
import EDU.purdue.jtb.syntaxtree.CharacterList;
import EDU.purdue.jtb.syntaxtree.ComplexRegularExpression;
import EDU.purdue.jtb.syntaxtree.ComplexRegularExpressionChoices;
import EDU.purdue.jtb.syntaxtree.ComplexRegularExpressionUnit;
import EDU.purdue.jtb.syntaxtree.Expansion;
import EDU.purdue.jtb.syntaxtree.ExpansionChoices;
import EDU.purdue.jtb.syntaxtree.ExpansionUnit;
import EDU.purdue.jtb.syntaxtree.ExpansionUnitTerm;
import EDU.purdue.jtb.syntaxtree.JavaCCInput;
import EDU.purdue.jtb.syntaxtree.JavaCCOptions;
import EDU.purdue.jtb.syntaxtree.JavaCodeProduction;
import EDU.purdue.jtb.syntaxtree.LexicalStateList;
import EDU.purdue.jtb.syntaxtree.LocalLookahead;
import EDU.purdue.jtb.syntaxtree.Node;
import EDU.purdue.jtb.syntaxtree.NodeList;
import EDU.purdue.jtb.syntaxtree.NodeListOptional;
import EDU.purdue.jtb.syntaxtree.NodeOptional;
import EDU.purdue.jtb.syntaxtree.NodeSequence;
import EDU.purdue.jtb.syntaxtree.NodeToken;
import EDU.purdue.jtb.syntaxtree.OptionBinding;
import EDU.purdue.jtb.syntaxtree.Production;
import EDU.purdue.jtb.syntaxtree.RegExprKind;
import EDU.purdue.jtb.syntaxtree.RegExprSpec;
import EDU.purdue.jtb.syntaxtree.RegularExprProduction;
import EDU.purdue.jtb.syntaxtree.RegularExpression;
import EDU.purdue.jtb.syntaxtree.TokenManagerDecls;
import EDU.purdue.jtb.visitor.DepthFirstVisitor;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;

public class Printer
extends DepthFirstVisitor {
    protected PrintWriter out;
    protected int nestLevel = 0;
    protected Spacing spc;
    protected JavaStringMaker javaStringMaker;

    public Printer() {
        this(System.out);
    }

    public Printer(OutputStream outputStream) {
        this.out = new PrintWriter(outputStream);
        this.spc = new Spacing(3);
        this.javaStringMaker = new JavaStringMaker(this.spc);
    }

    public Printer(Writer writer) {
        this(writer, new Spacing(3));
    }

    public Printer(Writer writer, Spacing spacing) {
        this.out = new PrintWriter(writer);
        this.spc = spacing;
        this.javaStringMaker = new JavaStringMaker(this.spc);
    }

    public void flushWriter() {
        this.out.flush();
    }

    protected String javaString(Node node) {
        return this.javaStringMaker.javaString(node);
    }

    public void setOut(Writer writer) {
        this.out = new PrintWriter(writer);
    }

    public void visit(BNFProduction bNFProduction) {
        this.nestLevel = 0;
        this.out.println(String.valueOf(this.javaString(bNFProduction.f0)) + " " + bNFProduction.f1 + this.javaString(bNFProduction.f2) + " " + bNFProduction.f3);
        this.out.println(String.valueOf(this.spc.spc) + this.javaString(bNFProduction.f4));
        this.out.println(String.valueOf(this.spc.spc) + bNFProduction.f5);
        this.spc.updateSpc(1);
        this.out.print(this.spc.spc);
        bNFProduction.f6.accept(this);
        this.out.println();
        this.spc.updateSpc(-1);
        this.out.print(String.valueOf(this.spc.spc) + bNFProduction.f7);
    }

    public void visit(CharacterDescriptor characterDescriptor) {
        characterDescriptor.f0.accept(this);
        characterDescriptor.f1.accept(this);
    }

    public void visit(CharacterList characterList) {
        characterList.f0.accept(this);
        characterList.f1.accept(this);
        if (characterList.f2.present()) {
            NodeSequence nodeSequence = (NodeSequence)characterList.f2.node;
            nodeSequence.elementAt(0).accept(this);
            Enumeration enumeration = ((NodeListOptional)nodeSequence.elementAt(1)).elements();
            while (enumeration.hasMoreElements()) {
                NodeSequence nodeSequence2 = (NodeSequence)enumeration.nextElement();
                this.out.print(String.valueOf(String.valueOf(nodeSequence2.elementAt(0))) + " ");
                nodeSequence2.elementAt(1).accept(this);
            }
        }
        characterList.f3.accept(this);
    }

    public void visit(ComplexRegularExpression complexRegularExpression) {
        this.visit(complexRegularExpression.f0, " ");
    }

    public void visit(ComplexRegularExpressionChoices complexRegularExpressionChoices) {
        complexRegularExpressionChoices.f0.accept(this);
        Enumeration enumeration = complexRegularExpressionChoices.f1.elements();
        while (enumeration.hasMoreElements()) {
            this.out.print(" ");
            this.visit((NodeSequence)enumeration.nextElement(), " ");
        }
    }

    public void visit(ComplexRegularExpressionUnit complexRegularExpressionUnit) {
        complexRegularExpressionUnit.f0.accept(this);
    }

    public void visit(Expansion expansion) {
        if (this.nestLevel == 0) {
            this.visit(expansion.f0, "\n" + this.spc.spc);
        } else {
            this.visit(expansion.f0, " ");
        }
    }

    public void visit(ExpansionChoices expansionChoices) {
        if (!expansionChoices.f1.present()) {
            expansionChoices.f0.accept(this);
        } else {
            ++this.nestLevel;
            expansionChoices.f0.accept(this);
            --this.nestLevel;
            Enumeration enumeration = expansionChoices.f1.elements();
            while (enumeration.hasMoreElements()) {
                NodeSequence nodeSequence = (NodeSequence)enumeration.nextElement();
                if (this.nestLevel != 0) {
                    this.out.print(" ");
                } else {
                    this.out.println();
                    this.out.print(this.spc.spc);
                }
                this.out.print(String.valueOf(String.valueOf(nodeSequence.elementAt(0))) + " ");
                ++this.nestLevel;
                nodeSequence.elementAt(1).accept(this);
                --this.nestLevel;
            }
        }
    }

    public void visit(ExpansionUnit expansionUnit) {
        switch (expansionUnit.f0.which) {
            case 0: {
                expansionUnit.f0.accept(this);
                break;
            }
            case 1: {
                this.out.println();
                this.out.print(this.spc.spc);
                this.out.print(this.javaString(expansionUnit.f0.choice));
                this.out.println();
                this.out.print(this.spc.spc);
                break;
            }
            case 2: {
                NodeSequence nodeSequence = (NodeSequence)expansionUnit.f0.choice;
                this.out.print(String.valueOf(String.valueOf(nodeSequence.elementAt(0))) + " ");
                ++this.nestLevel;
                nodeSequence.elementAt(1).accept(this);
                --this.nestLevel;
                this.out.print(" " + nodeSequence.elementAt(2));
                nodeSequence.elementAt(3).accept(this);
                break;
            }
            case 3: {
                NodeSequence nodeSequence = (NodeSequence)expansionUnit.f0.choice;
                this.out.print(String.valueOf(String.valueOf(nodeSequence.elementAt(0))) + " ");
                ++this.nestLevel;
                nodeSequence.elementAt(1).accept(this);
                --this.nestLevel;
                this.out.print(" " + nodeSequence.elementAt(2));
                break;
            }
            case 4: {
                expansionUnit.f0.accept(this);
                break;
            }
            default: {
                Errors.hardErr("n.f0.which = " + String.valueOf(expansionUnit.f0.which));
            }
        }
    }

    public void visit(ExpansionUnitTerm expansionUnitTerm) {
        expansionUnitTerm.f0.accept(this);
    }

    public void visit(JavaCCInput javaCCInput) {
        this.out.print(this.spc.spc);
        javaCCInput.f0.accept(this);
        this.out.println("\n");
        this.out.println(String.valueOf(this.spc.spc) + javaCCInput.f1 + javaCCInput.f2 + javaCCInput.f3 + javaCCInput.f4);
        this.out.println(String.valueOf(this.spc.spc) + this.javaString(javaCCInput.f5));
        this.out.println(String.valueOf(this.spc.spc) + javaCCInput.f6 + javaCCInput.f7 + javaCCInput.f8 + javaCCInput.f9 + "\n");
        this.out.print(this.spc.spc);
        this.visit(javaCCInput.f10, "\n\n" + this.spc.spc);
        this.out.println();
        this.flushWriter();
    }

    public void visit(JavaCCOptions javaCCOptions) {
        if (javaCCOptions.f0.present()) {
            NodeSequence nodeSequence = (NodeSequence)javaCCOptions.f0.node;
            NodeListOptional nodeListOptional = (NodeListOptional)nodeSequence.elementAt(2);
            this.out.println(String.valueOf(String.valueOf(nodeSequence.elementAt(0))) + " " + nodeSequence.elementAt(1));
            if (nodeListOptional.present()) {
                this.spc.updateSpc(1);
                this.out.print(this.spc.spc);
                this.visit(nodeListOptional, "\n" + this.spc.spc);
                this.out.println();
                this.spc.updateSpc(-1);
            }
            this.out.print(String.valueOf(this.spc.spc) + nodeSequence.elementAt(3));
        }
    }

    public void visit(JavaCodeProduction javaCodeProduction) {
        this.out.println(javaCodeProduction.f0);
        this.out.println(String.valueOf(this.spc.spc) + this.javaString(javaCodeProduction.f1) + " " + javaCodeProduction.f2 + this.javaString(javaCodeProduction.f3));
        this.out.print(String.valueOf(this.spc.spc) + this.javaString(javaCodeProduction.f4));
    }

    public void visit(LexicalStateList lexicalStateList) {
        if (lexicalStateList.f0.which == 0) {
            lexicalStateList.f0.accept(this);
        } else {
            NodeSequence nodeSequence = (NodeSequence)lexicalStateList.f0.choice;
            NodeListOptional nodeListOptional = (NodeListOptional)nodeSequence.elementAt(2);
            this.out.print(String.valueOf(nodeSequence.elementAt(0).toString()) + nodeSequence.elementAt(1).toString());
            if (nodeListOptional.present()) {
                Enumeration enumeration = nodeListOptional.elements();
                while (enumeration.hasMoreElements()) {
                    NodeSequence nodeSequence2 = (NodeSequence)enumeration.nextElement();
                    this.out.print(String.valueOf(String.valueOf(nodeSequence2.elementAt(0))) + " " + nodeSequence2.elementAt(1));
                }
            }
            this.out.print(nodeSequence.elementAt(3));
        }
    }

    public void visit(LocalLookahead localLookahead) {
        this.out.print(String.valueOf(localLookahead.f0.toString()) + localLookahead.f1.toString());
        localLookahead.f2.accept(this);
        this.visit(localLookahead.f3, " ");
        ++this.nestLevel;
        localLookahead.f4.accept(this);
        --this.nestLevel;
        this.visit(localLookahead.f5, " ");
        if (localLookahead.f6.present()) {
            NodeSequence nodeSequence = (NodeSequence)localLookahead.f6.node;
            this.out.print(String.valueOf(String.valueOf(nodeSequence.elementAt(0))) + " " + this.javaString(nodeSequence.elementAt(1)) + " " + nodeSequence.elementAt(2));
        }
        localLookahead.f7.accept(this);
    }

    protected void visit(Node node, String string) {
        NodeSequence nodeSequence = (NodeSequence)node;
        Enumeration enumeration = nodeSequence.elements();
        while (enumeration.hasMoreElements()) {
            ((Node)enumeration.nextElement()).accept(this);
            if (!enumeration.hasMoreElements()) continue;
            this.out.print(string);
        }
    }

    protected void visit(NodeList nodeList, String string) {
        Enumeration enumeration = nodeList.elements();
        while (enumeration.hasMoreElements()) {
            ((Node)enumeration.nextElement()).accept(this);
            if (!enumeration.hasMoreElements()) continue;
            this.out.print(string);
        }
    }

    protected void visit(NodeListOptional nodeListOptional, String string) {
        if (nodeListOptional.present()) {
            Enumeration enumeration = nodeListOptional.elements();
            while (enumeration.hasMoreElements()) {
                ((Node)enumeration.nextElement()).accept(this);
                if (!enumeration.hasMoreElements()) continue;
                this.out.print(string);
            }
        }
    }

    protected void visit(NodeOptional nodeOptional, String string) {
        if (nodeOptional.present()) {
            nodeOptional.node.accept(this);
            this.out.print(string);
        }
    }

    public void visit(NodeToken nodeToken) {
        this.out.print(nodeToken.tokenImage);
    }

    protected void visit(NodeToken nodeToken, String string) {
        this.out.print(String.valueOf(nodeToken.tokenImage) + string);
    }

    public void visit(OptionBinding optionBinding) {
        optionBinding.f0.accept(this);
        this.out.print(" " + optionBinding.f1 + " ");
        optionBinding.f2.accept(this);
        optionBinding.f3.accept(this);
    }

    public void visit(Production production) {
        production.f0.accept(this);
    }

    public void visit(RegExprKind regExprKind) {
        regExprKind.f0.accept(this);
    }

    public void visit(RegExprSpec regExprSpec) {
        regExprSpec.f0.accept(this);
        if (regExprSpec.f1.present()) {
            this.out.println();
            this.spc.updateSpc(1);
            this.out.print(String.valueOf(this.spc.spc) + this.javaString(regExprSpec.f1.node));
            this.spc.updateSpc(-1);
        }
        if (regExprSpec.f2.present()) {
            NodeSequence nodeSequence = (NodeSequence)regExprSpec.f2.node;
            this.out.print(" " + nodeSequence.elementAt(0) + " " + nodeSequence.elementAt(1));
        }
    }

    public void visit(RegularExprProduction regularExprProduction) {
        this.visit(regularExprProduction.f0, " ");
        regularExprProduction.f1.accept(this);
        this.out.print(" ");
        this.visit(regularExprProduction.f2, " ");
        this.out.println(regularExprProduction.f3);
        this.out.println(String.valueOf(this.spc.spc) + regularExprProduction.f4);
        this.spc.updateSpc(1);
        this.out.print(this.spc.spc);
        regularExprProduction.f5.accept(this);
        this.out.println();
        if (regularExprProduction.f6.present()) {
            this.out.print(this.spc.spc);
            Enumeration enumeration = regularExprProduction.f6.elements();
            while (enumeration.hasMoreElements()) {
                NodeSequence nodeSequence = (NodeSequence)enumeration.nextElement();
                this.out.print(String.valueOf(String.valueOf(nodeSequence.elementAt(0))) + " ");
                nodeSequence.elementAt(1).accept(this);
                this.out.println();
                if (!enumeration.hasMoreElements()) continue;
                this.out.print(this.spc.spc);
            }
        }
        this.spc.updateSpc(-1);
        this.out.print(this.spc.spc);
        regularExprProduction.f7.accept(this);
    }

    public void visit(RegularExpression regularExpression) {
        if (regularExpression.f0.which != 1) {
            regularExpression.f0.accept(this);
        } else {
            NodeSequence nodeSequence = (NodeSequence)regularExpression.f0.choice;
            NodeOptional nodeOptional = (NodeOptional)nodeSequence.elementAt(1);
            nodeSequence.elementAt(0).accept(this);
            if (nodeOptional.present()) {
                NodeSequence nodeSequence2 = (NodeSequence)nodeOptional.node;
                nodeSequence2.elementAt(0).accept(this);
                this.out.print(String.valueOf(nodeSequence2.elementAt(1).toString()) + nodeSequence2.elementAt(2).toString() + " ");
            }
            nodeSequence.elementAt(2).accept(this);
            nodeSequence.elementAt(3).accept(this);
        }
    }

    public void visit(TokenManagerDecls tokenManagerDecls) {
        tokenManagerDecls.f0.accept(this);
        tokenManagerDecls.f1.accept(this);
        this.out.println(String.valueOf(this.spc.spc) + this.javaString(tokenManagerDecls.f2));
    }
}

